/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import javax.swing.Icon;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.explorer.model.BaseDBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.property.PropertyInfo;

class DBObjectFolder
extends ObjectFolder
implements BaseDBObjectFolder {
    private DBObjectNode m_node;

    public DBObjectFolder(DBObject dBObject, DBObjectProvider dBObjectProvider, String string) {
        super(dBObject, dBObjectProvider, string);
    }

    public DBObjectFolder(DBObjectNode dBObjectNode) {
        super(null, DBObjectNodeUtil.findProvider((Object)dBObjectNode), null);
        this.m_node = dBObjectNode;
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        DBObject dBObject;
        DBObjectProvider dBObjectProvider = null;
        DBObjectProvider dBObjectProvider2 = this.getProvider();
        if (dBObjectProvider2 instanceof Database && ((dBObject = (DBObject)super.getObject()) == null || DBUtil.needsBuilding((DBObject)DBUtil.getSystemObject((DBObject)dBObject)))) {
            dBObjectProvider = dBObjectProvider2;
        }
        return dBObjectProvider;
    }

    void setDBObjectNode(DBObjectNode dBObjectNode) {
        if (this.m_node != null) {
            this.m_node = dBObjectNode;
            this.setObject(null);
        }
    }

    @Override
    protected boolean isIgnoredProperty(PropertyInfo propertyInfo, DBObjectProvider dBObjectProvider, Object object) {
        boolean bl = dBObjectProvider instanceof Database && object instanceof Index && "table".equals(propertyInfo.getPropertyName()) ? false : super.isIgnoredProperty(propertyInfo, dBObjectProvider, object);
        return bl;
    }

    @Override
    public String getObjectType() {
        String string = this.m_node == null ? BaseDBObjectFolder.super.getObjectType() : DBObjectNodeUtil.normalizeType((DBObjectTypeNode)this.m_node);
        return string;
    }

    public DBObject getDBObject() {
        return this.getObject();
    }

    @Override
    public String getObjectName() {
        String string = this.m_node == null ? BaseDBObjectFolder.super.getObjectName() : this.m_node.getObjectName();
        return string;
    }

    @Override
    public String getSchemaName() {
        String string = this.m_node == null ? BaseDBObjectFolder.super.getSchemaName() : DBObjectNodeUtil.getSchemaName((DBObjectTypeNode)this.m_node);
        return string;
    }

    @Override
    public Object getKey() {
        return ExplorerModelHelper.getKeyForObject(this.getObject(), this.getProperty());
    }

    protected DBObject getObject() {
        DBObject dBObject = (DBObject)super.getObject();
        if (dBObject == null && this.m_node != null && (dBObject = this.m_node.getDBObject()) != null) {
            this.setObject(dBObject);
        }
        return dBObject;
    }

    @Override
    protected Icon createIcon() {
        Icon icon = this.m_node == null ? super.createIcon() : this.m_node.getIcon();
        return icon;
    }

    @Override
    protected String createLabel() {
        String string = this.m_node == null ? super.createLabel() : this.m_node.getShortLabel();
        return string;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

