/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.shardconsole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.binding.ListExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.control.GridViewControl;
import oracle.dbtools.raptor.metrics.facet.AbstractGridViewMonitor;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

public class ShardMonitor
extends AbstractGridViewMonitor {
    private final ObjectProperty<PanelTemplate<Region>> shardCellPanelTemplateProperty = new SimpleObjectProperty((Object)this, "shardCellPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> directorCellPanelTemplateProperty = new SimpleObjectProperty((Object)this, "directorCellPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> groupHeaderPanelTemplateProperty = new SimpleObjectProperty((Object)this, "groupLabelPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> spaceHeaderPanelTemplateProperty = new SimpleObjectProperty((Object)this, "spaceLabelPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> regionHeaderPanelTemplateProperty = new SimpleObjectProperty((Object)this, "regionLabelPanelTemplate");
    private final ObjectProperty<PanelTemplate<Region>> directorHeaderPanelTemplateProperty = new SimpleObjectProperty((Object)this, "regionLabelPanelTemplate");
    private final IntegerProperty wrapAroundProperty = new SimpleIntegerProperty((Object)this, "wrapAround", 0);
    private GridPane[][] cellPanels;

    public ShardMonitor() {
        this.init((InstanceListener)new Listener());
    }

    public PanelTemplate<Region> getShardCellPanelTemplate() {
        return (PanelTemplate)this.shardCellPanelTemplateProperty.get();
    }

    public void setShardCellPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.shardCellPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> shardCellPanelTemplateProperty() {
        return this.shardCellPanelTemplateProperty;
    }

    public PanelTemplate<Region> getDirectorCellPanelTemplate() {
        return (PanelTemplate)this.directorCellPanelTemplateProperty.get();
    }

    public void setDirectorCellPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.directorCellPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> directorCellPanelTemplateProperty() {
        return this.directorCellPanelTemplateProperty;
    }

    public PanelTemplate<Region> getGroupHeaderPanelTemplate() {
        return (PanelTemplate)this.groupHeaderPanelTemplateProperty.get();
    }

    public void setGroupHeaderPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.groupHeaderPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> groupHeaderPanelTemplateProperty() {
        return this.groupHeaderPanelTemplateProperty;
    }

    public PanelTemplate<Region> getSpaceHeaderPanelTemplate() {
        return (PanelTemplate)this.spaceHeaderPanelTemplateProperty.get();
    }

    public void setSpaceHeaderPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.spaceHeaderPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> spaceHeaderPanelTemplateProperty() {
        return this.spaceHeaderPanelTemplateProperty;
    }

    public PanelTemplate<Region> getRegionHeaderPanelTemplate() {
        return (PanelTemplate)this.regionHeaderPanelTemplateProperty.get();
    }

    public void setRegionHeaderPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.regionHeaderPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> regionHeaderPanelTemplateProperty() {
        return this.regionHeaderPanelTemplateProperty;
    }

    public PanelTemplate<Region> getDirectorHeaderPanelTemplate() {
        return (PanelTemplate)this.directorHeaderPanelTemplateProperty.get();
    }

    public void setDirectorHeaderPanelTemplate(PanelTemplate<Region> panelTemplate) {
        this.directorHeaderPanelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Region>> directorHeaderPanelTemplateProperty() {
        return this.directorHeaderPanelTemplateProperty;
    }

    public int getWrapAround() {
        return this.wrapAroundProperty.get();
    }

    public void setWrapAround(int n) {
        this.wrapAroundProperty.set(n);
    }

    public IntegerProperty wrapAroundProperty() {
        return this.wrapAroundProperty;
    }

    public void zoomIn() {
        Platform.runLater(() -> {
            GridViewControl gridViewControl = this.getGridView();
            gridViewControl.setScale(gridViewControl.getScale() / 0.8);
        });
    }

    public void zoomOut() {
        Platform.runLater(() -> {
            GridViewControl gridViewControl = this.getGridView();
            gridViewControl.setScale(gridViewControl.getScale() * 0.8);
        });
    }

    public void zoomActual() {
        Platform.runLater(() -> {
            GridViewControl gridViewControl = this.getGridView();
            gridViewControl.setScale(1.0);
        });
    }

    protected Node createCellPanel(int n, int n2) {
        return this.cellPanels[n][n2];
    }

    private void update() {
        Object object;
        Object object2;
        ArrayList[][] arrayListArray;
        PanelTemplate<Region> panelTemplate;
        PanelTemplate<Region> panelTemplate22;
        PanelTemplate<Region> panelTemplate32;
        ListExpression listExpression = this.getItem().valueProperty();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        TreeMap<Object, Integer> treeMap2 = new TreeMap<Object, Integer>();
        for (Object object3 : listExpression) {
            panelTemplate32 = (String)object3.get("Region", String.class).get();
            treeMap.put((String)panelTemplate32, (Integer)null);
            panelTemplate22 = (PanelTemplate<Region>)object3.get("Space", String.class).get();
            if (panelTemplate22 == null) continue;
            treeMap2.put(panelTemplate22, null);
        }
        this.getColumns().clear();
        int n = 0;
        for (PanelTemplate<Region> panelTemplate32 : treeMap.keySet()) {
            treeMap.put((String)panelTemplate32, n++);
            panelTemplate22 = this.getRegionHeaderPanelTemplate();
            panelTemplate = Collections.singletonMap("Name", panelTemplate32);
            arrayListArray = panelTemplate22.newPanel(panelTemplate);
            object2 = (Node)arrayListArray.getRootObject();
            this.getColumns().add(object2);
        }
        this.getRows().clear();
        int n2 = 1;
        for (PanelTemplate<Region> panelTemplate22 : treeMap2.keySet()) {
            treeMap2.put(panelTemplate22, n2++);
            panelTemplate = this.getSpaceHeaderPanelTemplate();
            arrayListArray = Collections.singletonMap("Name", panelTemplate22);
            object2 = panelTemplate.newPanel((Map)arrayListArray);
            Node node = (Node)object2.getRootObject();
            this.getRows().add(node);
        }
        panelTemplate32 = this.getDirectorHeaderPanelTemplate();
        panelTemplate22 = panelTemplate32.newPanel();
        panelTemplate = (PanelTemplate<Region>)panelTemplate22.getRootObject();
        this.getRows().add(0, panelTemplate);
        treeMap2.put("$DIRECTORS", 0);
        arrayListArray = new ArrayList[treeMap.size()][treeMap2.size()];
        for (Node node : listExpression) {
            String string;
            int n3;
            object = (String)node.get("Region", String.class).get();
            int n4 = (Integer)treeMap.get(object);
            ArrayList<Node> arrayList = arrayListArray[n4][n3 = (string = (String)node.get("Space", String.class).get()) != null ? (Integer)treeMap2.get(string) : 0];
            if (arrayList == null) {
                arrayListArray[n4][n3] = arrayList = new ArrayList<Node>();
            }
            arrayList.add(node);
        }
        this.cellPanels = new GridPane[treeMap.size()][treeMap2.size()];
        for (int i = 0; i < treeMap.size(); ++i) {
            for (int j = 0; j < treeMap2.size(); ++j) {
                object = arrayListArray[i][j];
                if (object == null) {
                    this.cellPanels[i][j] = new GridPane();
                    continue;
                }
                if (j == 0) {
                    this.cellPanels[i][0] = this.initDirectorsPanel((List<DXRow>)object);
                    continue;
                }
                this.cellPanels[i][j] = this.initShardsPanel((List<DXRow>)object);
            }
        }
    }

    private GridPane initDirectorsPanel(List<DXRow> list) {
        int n = this.getWrapAround();
        int n2 = n - 1;
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"director-grid");
        int n3 = 0;
        int n4 = 0;
        for (DXRow dXRow : list) {
            String string = (String)dXRow.get("Director", String.class).get();
            boolean bl = (Boolean)dXRow.get("MasterDirector", Boolean.class).get();
            String string2 = (String)dXRow.get("DirectorRole", String.class).get();
            String string3 = (String)dXRow.get("Host", String.class).get();
            PanelTemplate<Region> panelTemplate = this.getDirectorCellPanelTemplate();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Director", string);
            hashMap.put("MasterDirector", bl);
            hashMap.put("DirectorRole", string2);
            hashMap.put("Host", string3);
            TemplateInstance templateInstance = panelTemplate.newPanel(hashMap);
            Region region = (Region)templateInstance.getRootObject();
            gridPane.add((Node)region, n4, n3);
            if (n > 0 && n4 == n2) {
                ++n3;
                n4 = 0;
                continue;
            }
            ++n4;
        }
        return gridPane;
    }

    private GridPane initShardsPanel(List<DXRow> list) {
        DXRow dXRow2;
        TreeMap<String, DXRow> treeMap = new TreeMap<String, DXRow>();
        TreeMap treeMap2 = new TreeMap();
        for (DXRow dXRow2 : list) {
            SortedMap sortedMap;
            String string = (String)dXRow2.get("Group", String.class).get();
            String string2 = (String)dXRow2.get("Shard", String.class).get();
            if (string == null) {
                sortedMap = treeMap;
            } else {
                sortedMap = (SortedMap)treeMap2.get(string);
                if (sortedMap == null) {
                    sortedMap = new TreeMap();
                    treeMap2.put(string, sortedMap);
                }
            }
            sortedMap.put((String)string2, (DXRow)dXRow2);
        }
        int n = this.getWrapAround();
        dXRow2 = new GridPane();
        dXRow2.getStyleClass().add((Object)"group-shard-grid");
        int n2 = 0;
        if (!treeMap.isEmpty()) {
            n2 = this.addGroupRow((GridPane)dXRow2, n2, null, treeMap, n);
        }
        for (SortedMap sortedMap : treeMap2.keySet()) {
            SortedMap sortedMap2 = (SortedMap)treeMap2.get(sortedMap);
            n2 = this.addGroupRow((GridPane)dXRow2, n2, (String)((Object)sortedMap), sortedMap2, n);
        }
        return dXRow2;
    }

    private int addGroupRow(GridPane gridPane, int n, String string, SortedMap<String, DXRow> sortedMap, int n2) {
        Object object;
        TemplateInstance templateInstance;
        int n3 = 0;
        int n4 = n2 - 1;
        if (string != null) {
            PanelTemplate<Region> panelTemplate = this.getGroupHeaderPanelTemplate();
            Map<String, String> object2 = Collections.singletonMap("Name", string);
            templateInstance = panelTemplate.newPanel(object2);
            object = (Region)templateInstance.getRootObject();
            gridPane.add((Node)object, 0, n);
            ++n3;
            if (n2 > 0) {
                ++n4;
            }
        }
        for (String string2 : sortedMap.keySet()) {
            templateInstance = (DXRow)sortedMap.get(string2);
            object = (String)templateInstance.get("ShardRole", String.class).get();
            boolean bl = (Boolean)templateInstance.get("Primary", Boolean.class).get();
            boolean bl2 = (Boolean)templateInstance.get("Deployed", Boolean.class).get();
            String string3 = (String)templateInstance.get("DbState", String.class).get();
            long l = (Long)templateInstance.get("ReplicaSet", Long.class).get();
            String string4 = (String)templateInstance.get("ConnectString", String.class).get();
            long l2 = (Long)templateInstance.get("ChunkCount", Long.class).get();
            PanelTemplate<Region> panelTemplate = this.getShardCellPanelTemplate();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Shard", string2);
            hashMap.put("ShardRole", object);
            hashMap.put("Primary", bl);
            hashMap.put("Deployed", bl2);
            hashMap.put("DbState", string3);
            hashMap.put("ReplicaSet", l);
            hashMap.put("ConnectString", string4);
            hashMap.put("ChunkCount", l2);
            TemplateInstance templateInstance2 = panelTemplate.newPanel(hashMap);
            Region region = (Region)templateInstance2.getRootObject();
            gridPane.add((Node)region, n3, n);
            if (n2 > 0 && n3 == n4) {
                ++n;
                n3 = string != null ? 1 : 0;
                continue;
            }
            ++n3;
        }
        return n + 1;
    }

    protected class Listener
    extends AbstractGridViewMonitor.Listener {
        protected Listener() {
            super((AbstractGridViewMonitor)ShardMonitor.this);
        }

        public void onOpen(Context context) {
            super.onOpen(context);
            ShardMonitor.this.getItem().updatingProperty().addListener((observableValue, bl, bl2) -> {
                if (context.isDataStreamEnabled() && !bl2.booleanValue()) {
                    ShardMonitor.this.update();
                }
            });
        }
    }
}

