/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.preference;

import javafx.util.Duration;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.metrics.facet.TimeSeriesAxisProperties;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TemplateObjectVisitor;

public class PreferenceVisitor
implements TemplateObjectVisitor<TimeSeriesAxisProperties> {
    private final Duration timeAxisTickInterval;
    private final int timeAxisTickIntervalCount;

    public PreferenceVisitor() {
        DBConfig dBConfig = DBConfig.getInstance();
        int n = dBConfig.getInt("INSTANCE_VIEWER_GRAPH_DURATION");
        if (n <= 2) {
            this.timeAxisTickInterval = Duration.seconds((double)30.0);
            this.timeAxisTickIntervalCount = 4;
        } else if (n <= 5) {
            this.timeAxisTickInterval = Duration.minutes((double)1.0);
            this.timeAxisTickIntervalCount = 5;
        } else if (n <= 10) {
            this.timeAxisTickInterval = Duration.minutes((double)2.0);
            this.timeAxisTickIntervalCount = 5;
        } else if (n <= 30) {
            this.timeAxisTickInterval = Duration.minutes((double)5.0);
            this.timeAxisTickIntervalCount = 6;
        } else {
            this.timeAxisTickInterval = Duration.minutes((double)10.0);
            this.timeAxisTickIntervalCount = 6;
        }
    }

    public Class<TimeSeriesAxisProperties> getType() {
        return TimeSeriesAxisProperties.class;
    }

    public void onVisit(Context context, TimeSeriesAxisProperties timeSeriesAxisProperties) {
        timeSeriesAxisProperties.setTickInterval(this.timeAxisTickInterval);
        timeSeriesAxisProperties.setTickIntervalCount(this.timeAxisTickIntervalCount);
    }
}

