/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.common;

import java.awt.Component;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.Drill.DBADrillLink;
import oracle.dbtools.raptor.dba.navigator.metrics.DbaMetricsArb;
import oracle.dbtools.raptor.dba.navigator.metrics.DbaMetricsUtil;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.metrics.panel.Action;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class DrillToDataGuard
implements Action {
    private final StringProperty connectionCategoryProperty = new SimpleStringProperty((Object)this, "connectionCategory");
    private final StringProperty connectionKeyProperty = new SimpleStringProperty((Object)this, "connectionKey");

    public DrillToDataGuard() {
        this.init();
    }

    public String getConnectionCategory() {
        return (String)this.connectionCategoryProperty.get();
    }

    public void setConnectionCategory(String string) {
        this.connectionCategoryProperty.set((Object)string);
    }

    public StringProperty connectionCategoryProperty() {
        return this.connectionCategoryProperty;
    }

    public String getConnectionKey() {
        return (String)this.connectionKeyProperty.get();
    }

    public void setConnectionKey(String string) {
        this.connectionKeyProperty.set((Object)string);
    }

    public StringProperty connectionKeyProperty() {
        return this.connectionKeyProperty;
    }

    public Boolean get() {
        DbaMetricsUtil.callAssociatedConnectionNameAction(this.getConnectionCategory(), this.getConnectionKey(), string -> this.runHandleTask((String)string));
        return true;
    }

    private void runHandleTask(final String string) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DbaMetricsArb.getString("CONNECTING"), false, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                block6: {
                    try {
                        Connection connection = Connections.getInstance().getConnection(string);
                        if (connection != null) {
                            try {
                                if (DbaUtil.isDataguard(connection)) {
                                    DrillToDataGuard.this.showDataGuardConsole(connection, string);
                                    break block6;
                                }
                                SwingUtilities.invokeLater(() -> MessageDialog.information((Component)Ide.getMainWindow(), (Object)DbaMetricsArb.format("NOT_DATAGUARD", Connections.getDisplayName((String)string)), (String)DbaMetricsArb.getString("INFO"), null));
                            }
                            catch (RuntimeException runtimeException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "unable to perform action", runtimeException);
                            }
                            break block6;
                        }
                        SwingUtilities.invokeLater(() -> MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaMetricsArb.format("CONNECTION_DOESNT_EXIST", Connections.getDisplayName((String)string)), (String)DbaMetricsArb.getString("ERROR"), null));
                    }
                    catch (DBException dBException) {
                        SwingUtilities.invokeLater(() -> MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaMetricsArb.format("UNABLE_TO_CONNECT", Connections.getDisplayName((String)string), dBException.getLocalizedMessage()), (String)DbaMetricsArb.getString("ERROR"), null));
                    }
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void showDataGuardConsole(Connection connection, String string) {
        String string2 = DbaUtil.getUserName(connection);
        DBADrillLink dBADrillLink = new DBADrillLink();
        dBADrillLink.setType("DATAGUARD");
        dBADrillLink.setOwner(string2);
        dBADrillLink.setConnName(string);
        dBADrillLink.performDrill();
    }
}

