/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics;

import java.net.URI;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.dba.navigator.metrics.DbaMetricsArb;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public class DbaMetricsUtil {
    private static PropertyStoreImpl thePropertyStore = new PropertyStoreImpl();
    private static final Map<String, Set<Consumer<String>>> listenerMap = new HashMap<String, Set<Consumer<String>>>();

    public static String getAssociatedConnectionName(String string, String string2) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        PropertyStoreImpl propertyStoreImpl = DbaMetricsUtil.getPropertyStore();
        String string4 = propertyStoreImpl.get(string3);
        return string4 != null ? Connections.getDisplayName((String)string4) : null;
    }

    public static void addAssociatedConnectionNameListener(String string, String string2, Consumer<String> consumer) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        Set<Consumer<String>> set = listenerMap.get(string3);
        if (set == null) {
            set = new HashSet<Consumer<String>>();
            listenerMap.put(string3, set);
        }
        set.add(consumer);
    }

    public static void removeAssociatedConnectionNameListener(String string, String string2, Consumer<String> consumer) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        Set<Consumer<String>> set = listenerMap.get(string3);
        if (set != null) {
            set.remove(consumer);
            if (set.isEmpty()) {
                listenerMap.remove(string3);
            }
        }
    }

    public static void callAssociatedConnectionNameAction(String string, String string2, Consumer<String> consumer) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        PropertyStoreImpl propertyStoreImpl = DbaMetricsUtil.getPropertyStore();
        String string4 = propertyStoreImpl.get(string3);
        if (string4 != null) {
            consumer.accept(string4);
        } else {
            SwingUtilities.invokeLater(() -> {
                Set<Consumer<String>> set;
                String string2 = ConnectionSelectorUI.getConnection((String)DbaMetricsArb.getString("INSTANCE_VIEWER_CONNECTION"), (String)DbaMetricsArb.getString("SELECT_CONNECTION"), null, (boolean)true, (boolean)false);
                if (string2 != null) {
                    propertyStoreImpl.set(string3, string2);
                    consumer.accept(string2);
                }
                if ((set = listenerMap.get(string3)) != null) {
                    String string3 = string2 != null ? Connections.getDisplayName((String)string2) : null;
                    for (Consumer<String> consumer2 : set) {
                        consumer2.accept(string3);
                    }
                }
            });
        }
    }

    public static void editConnectionNameAssociation(String string, String string2) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        PropertyStoreImpl propertyStoreImpl = DbaMetricsUtil.getPropertyStore();
        SwingUtilities.invokeLater(() -> {
            Set<Consumer<String>> set;
            String string2 = ConnectionSelectorUI.getConnection((String)DbaMetricsArb.getString("INSTANCE_VIEWER_CONNECTION"), (String)DbaMetricsArb.getString("SELECT_CONNECTION"), (String)propertyStoreImpl.get(string3), (boolean)true, (boolean)false);
            if (string2 != null) {
                propertyStoreImpl.set(string3, string2);
            }
            if ((set = listenerMap.get(string3)) != null) {
                String string3 = string2 != null ? Connections.getDisplayName((String)string2) : null;
                for (Consumer<String> consumer : set) {
                    consumer.accept(string3);
                }
            }
        });
    }

    public static void removeConnectionNameAssociation(String string, String string2) {
        String string3 = DbaMetricsUtil.getConnectionNameKey(string, string2);
        PropertyStoreImpl propertyStoreImpl = DbaMetricsUtil.getPropertyStore();
        SwingUtilities.invokeLater(() -> {
            propertyStoreImpl.remove(string3);
            Set<Consumer<String>> set = listenerMap.get(string3);
            if (set != null) {
                for (Consumer<String> consumer : set) {
                    consumer.accept(null);
                }
            }
        });
    }

    public static void dbShut(String string) throws SQLException {
        try (OracleConnection oracleConnection = DbaMetricsUtil.getShutStartConnection(string, false);){
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
            try (Statement statement = oracleConnection.createStatement();){
                statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
                statement.executeUpdate("ALTER DATABASE DISMOUNT");
            }
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
        }
        DXService.requestSourceKeepAlive((URI)DXIds.newId((String)"sql", (String)string, (String)"DbSql"), null);
    }

    public static void dbStart(String string) throws SQLException {
        try (OracleConnection oracleConnection = DbaMetricsUtil.getShutStartConnection(string, true);){
            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
        }
        oracleConnection = DbaMetricsUtil.getShutStartConnection(string, false);
        try (Statement statement = oracleConnection.createStatement();){
            statement.executeUpdate("ALTER DATABASE MOUNT");
            statement.executeUpdate("ALTER DATABASE OPEN");
        }
        finally {
            if (oracleConnection != null) {
                oracleConnection.close();
            }
        }
        DXService.requestSourceKeepAlive((URI)DXIds.newId((String)"sql", (String)string, (String)"DbSql"), null);
    }

    private static OracleConnection getShutStartConnection(String string, boolean bl) throws SQLException {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            throw new IllegalArgumentException("connectionName");
        }
        Properties properties2 = new Properties();
        properties2.setProperty("user", properties.getProperty("user"));
        properties2.setProperty("password", properties.getProperty("password"));
        properties2.setProperty("internal_logon", properties.getProperty("role"));
        if (bl) {
            properties2.setProperty("prelim_auth", "true");
        }
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setConnectionProperties(properties2);
        oracleDataSource.setURL(properties.getProperty("customUrl"));
        return (OracleConnection)oracleDataSource.getConnection();
    }

    private static String getConnectionNameKey(String string, String string2) {
        return string + "." + string2 + "#connectionName";
    }

    private static PropertyStoreImpl getPropertyStore() {
        if (thePropertyStore == null) {
            thePropertyStore = new PropertyStoreImpl();
        }
        return thePropertyStore;
    }

    private static class PropertyStoreImpl
    extends HashStructureAdapter {
        PropertyStoreImpl() {
            super(PropertyStoreImpl.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DbaMetricsUtil.class.getPackage().getName()));
        }

        String get(String string) {
            return this._hash.getString(string);
        }

        void set(String string, String string2) {
            this._hash.putString(string, string2);
        }

        void remove(String string) {
            this._hash.remove(string);
        }
    }
}

