/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.DbInstancePanel;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.RowSelectionPanel;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;

public class SnapshotPanel
extends JPanel {
    private final Connection conn;
    private final CardLayoutPanel cardPanel;
    private final String defaultDbId;
    private String currentInstanceID;
    private String currentDbID;
    private RowSelectionPanel baselineSelectionPanel;
    private RowSelectionPanel startSnapshotPanel;
    private RowSelectionPanel endSnapshotPanel;
    private DbInstancePanel dbInstancePanel;
    private PropertyChangeSupport changeSupport;

    public SnapshotPanel(Connection connection, String string, boolean bl, String string2, boolean bl2, String string3, boolean bl3) {
        this.conn = connection;
        this.defaultDbId = string3;
        this.currentInstanceID = string2;
        this.currentDbID = string3;
        this.setLayout(new GridBagLayout());
        if (string != null) {
            this.setBorder(new TitledBorder(string));
        }
        this.changeSupport = new PropertyChangeSupport(this);
        if (bl || bl2) {
            this.dbInstancePanel = new DbInstancePanel(connection, bl, string2, bl2, string3, bl3);
            this.dbInstancePanel.addPropertyChangeListener(propertyChangeEvent -> {
                this.currentInstanceID = this.dbInstancePanel.instanceNumber();
                this.currentDbID = this.dbInstancePanel.dbId();
                this.resetSnapIdRange();
                this.changeSupport.firePropertyChange(null, null, null);
            });
        }
        TreeMap<String, JPanel> treeMap = new TreeMap<String, JPanel>();
        treeMap.put(DisplayArb.getString("PERF_BY_SNAPSHOT"), this.createSnapshotPanel(this.currentInstanceID, this.currentDbID));
        treeMap.put(DisplayArb.getString("PERF_BY_BASELINE"), this.createBaselinePanel(this.currentInstanceID, this.currentDbID));
        this.cardPanel = new CardLayoutPanel(treeMap, null, CardLayoutPanel.Type.PLAIN);
        this.cardPanel.setSelectedItem((Object)DisplayArb.getString("PERF_BY_SNAPSHOT"));
        this.cardPanel.addItemListener(itemEvent -> this.changeSupport.firePropertyChange(null, null, null));
        if (bl || bl2) {
            this.add((Component)this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.dbInstancePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        } else {
            this.add((Component)this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean baselineSelected() {
        return this.cardPanel.getSelectedItem().equals(DisplayArb.getString("PERF_BY_BASELINE"));
    }

    public String instanceNumber() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.instanceNumber() : this.currentInstanceID;
    }

    public boolean hasMultipleInstanceNumbers() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.hasMultipleInstanceNumbers() : false;
    }

    public String dbId() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.dbId() : this.defaultDbId;
    }

    public String baselineName() {
        return this.baselineSelectionPanel.getSelectedItemId();
    }

    public String startSnapId() {
        return this.startSnapshotPanel.getSelectedItemId();
    }

    public String endSnapId() {
        return this.endSnapshotPanel.getSelectedItemId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] resolvedSnapshotIds() {
        String[] stringArray;
        block7: {
            block8: {
                stringArray = new String[2];
                if (!this.baselineSelected()) break block8;
                if (!Connections.getInstance().lock(this.conn)) break block7;
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", this.baselineName());
                    resultSet = dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getBaselineSnaps"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            stringArray[0] = resultSet.getString(1);
                            stringArray[1] = resultSet.getString(2);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
                Connections.getInstance().unlock(this.conn);
                break block7;
            }
            stringArray[0] = this.startSnapId();
            stringArray[1] = this.endSnapId();
        }
        return stringArray;
    }

    private JPanel createBaselinePanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("INSTANCE_ID", string);
        hashMap.put("DB_ID", string2);
        this.baselineSelectionPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getBaselines"), hashMap, new String[]{DisplayArb.getString("PERF_BASELINE_NAME"), DisplayArb.getString("PERF_START_SNAPSHOT_TIME"), DisplayArb.getString("PERF_END_SNAPSHOT_TIME")}, 30);
        this.baselineSelectionPanel.addPropertyChangeListener(propertyChangeEvent -> this.changeSupport.firePropertyChange(null, null, null));
        jPanel.add((Component)new JLabel(DisplayArb.getString("PERF_BASELINE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.baselineSelectionPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        return jPanel;
    }

    private JPanel createSnapshotPanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("INSTANCE_ID", string);
        hashMap.put("DB_ID", string2);
        hashMap.put("MIN_ID", Integer.MIN_VALUE);
        this.startSnapshotPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getSnapshots"), hashMap, new String[]{DisplayArb.getString("PERF_SNAPSHOT_ID"), DisplayArb.getString("PERF_START_INTERVAL_TIME"), DisplayArb.getString("PERF_END_INTERVAL_TIME")}, 8);
        this.startSnapshotPanel.addPropertyChangeListener(propertyChangeEvent -> this.onIdChanged(this.startSnapshotPanel, (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue(), () -> this.resetEndSnapIdRange()));
        this.endSnapshotPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getSnapshots"), hashMap, new String[]{DisplayArb.getString("PERF_SNAPSHOT_ID"), DisplayArb.getString("PERF_START_INTERVAL_TIME"), DisplayArb.getString("PERF_END_INTERVAL_TIME")}, 8);
        this.endSnapshotPanel.addPropertyChangeListener(propertyChangeEvent -> this.onIdChanged(this.endSnapshotPanel, (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue(), null));
        jPanel.add((Component)new JLabel(DisplayArb.getString("PERF_START_SNAPSHOT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.startSnapshotPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("PERF_END_SNAPSHOT")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        jPanel.add((Component)this.endSnapshotPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        return jPanel;
    }

    private void onIdChanged(RowSelectionPanel rowSelectionPanel, String string, String string2, Runnable runnable) {
        try {
            Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            rowSelectionPanel.setSelectedItemId(string);
            return;
        }
        this.changeSupport.firePropertyChange(null, null, null);
        if (runnable != null && !string2.trim().equals(string.trim())) {
            runnable.run();
        }
    }

    private void resetSnapIdRange() {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("INSTANCE_ID", this.currentInstanceID);
            hashMap.put("DB_ID", this.currentDbID);
            hashMap.put("MIN_ID", Integer.MIN_VALUE);
            this.startSnapshotPanel.reset(hashMap, true);
            this.endSnapshotPanel.reset(hashMap, true);
        }
        catch (Exception exception) {
            Logger.getLogger(SnapshotPanel.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void resetEndSnapIdRange() {
        try {
            int n = Integer.parseInt(this.startSnapId());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("INSTANCE_ID", this.currentInstanceID);
            hashMap.put("DB_ID", this.currentDbID);
            hashMap.put("MIN_ID", n);
            this.endSnapshotPanel.reset(hashMap, false);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(SnapshotPanel.class.getName()).log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
        }
    }
}

