/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.PerformanceReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.SnapshotPanel;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.Toolbar;

public class DiffReport
extends PerformanceReport {
    private SnapshotPanel firstSnapPanel;
    private SnapshotPanel secondSnapPanel;

    public DiffReport(Connection connection, Toolbar toolbar) {
        super(connection, toolbar);
    }

    @Override
    protected JPanel createConfigurePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.firstSnapPanel = new SnapshotPanel(this.conn, DisplayArb.getString("PERF_FIRST_SNAPSHOT_RANGE"), this.isMultiInstance(), this.defaultInstance(), this.isMultiDbId(), this.defaultDbId(), this.dbSupportsGlobal());
        this.firstSnapPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiffReport.this.enableGenerate(DiffReport.this.isSnapshotRangeValid(DiffReport.this.firstSnapPanel) && DiffReport.this.isSnapshotRangeValid(DiffReport.this.secondSnapPanel));
            }
        });
        this.secondSnapPanel = new SnapshotPanel(this.conn, DisplayArb.getString("PERF_SECOND_SNAPSHOT_RANGE"), this.isMultiInstance(), this.defaultInstance(), this.isMultiDbId(), this.defaultDbId(), this.dbSupportsGlobal());
        this.secondSnapPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiffReport.this.enableGenerate(DiffReport.this.isSnapshotRangeValid(DiffReport.this.firstSnapPanel) && DiffReport.this.isSnapshotRangeValid(DiffReport.this.secondSnapPanel));
            }
        });
        jPanel.add((Component)this.firstSnapPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.secondSnapPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeReport(Writer writer) {
        boolean bl;
        block10: {
            bl = false;
            String[] stringArray = this.firstSnapPanel.resolvedSnapshotIds();
            String[] stringArray2 = this.secondSnapPanel.resolvedSnapshotIds();
            try {
                if (!Connections.getInstance().lock(this.conn)) break block10;
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("FIRST_DB_ID", this.firstSnapPanel.dbId());
                    hashMap.put("FIRST_INSTANCE_NUMBER", this.firstSnapPanel.instanceNumber());
                    hashMap.put("FIRST_START_ID", stringArray[0]);
                    hashMap.put("FIRST_END_ID", stringArray[1]);
                    hashMap.put("SECOND_DB_ID", this.secondSnapPanel.dbId());
                    hashMap.put("SECOND_INSTANCE_NUMBER", this.secondSnapPanel.instanceNumber());
                    hashMap.put("SECOND_START_ID", stringArray2[0]);
                    hashMap.put("SECOND_END_ID", stringArray2[1]);
                    resultSet = this.firstSnapPanel.hasMultipleInstanceNumbers() || this.secondSnapPanel.hasMultipleInstanceNumbers() ? dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getGlobalDiffReport"), hashMap) : dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getDiffReport"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            Object object = resultSet.getString(1);
                            if (object == null) {
                                object = "";
                            }
                            object = ((String)object).trim() + "\n";
                            writer.write((String)object);
                        }
                        bl = true;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block10;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
                Connections.getInstance().unlock(this.conn);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return bl;
    }

    private boolean isSnapshotRangeValid(SnapshotPanel snapshotPanel) {
        boolean bl;
        String string = snapshotPanel.instanceNumber();
        boolean bl2 = bl = string != null && !string.equals("");
        if (bl) {
            if (snapshotPanel.baselineSelected()) {
                String string2 = snapshotPanel.baselineName();
                bl = string2 != null && !string2.equals("");
            } else {
                String string3 = snapshotPanel.startSnapId();
                String string4 = snapshotPanel.endSnapId();
                boolean bl3 = bl = string3 != null && !string3.equals("") && string4 != null && !string4.equals("");
                if (bl) {
                    try {
                        int n = Integer.parseInt(string3);
                        int n2 = Integer.parseInt(string4);
                        bl = n2 > n;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }
}

