/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.ASHReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.AWRReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.DiffReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.PerformanceReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.SQLReport;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;

public class PerformanceReportDisplay
extends DisplayAdapter
implements IDisplay {
    private JPanel panel;
    private boolean isRefreshing = false;
    private PerformanceReport report = null;

    private void init() {
        this.isRefreshing = true;
        this.panel.removeAll();
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DisplayArb.getString("LOAD_TASK_NAME"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                Type type = Type.valueOf((String)PerformanceReportDisplay.this.getExtValues().get("TYPE"));
                if (type == Type.AWR) {
                    type = Type.valueOf(PerformanceReportDisplay.this.getBindMap().get("VIEWER_TYPE").toString());
                }
                switch (type) {
                    case ASH: {
                        PerformanceReportDisplay.this.report = new ASHReport(PerformanceReportDisplay.this.getConnection(), PerformanceReportDisplay.this.getToolbar());
                        break;
                    }
                    case AWR: {
                        PerformanceReportDisplay.this.report = new AWRReport(PerformanceReportDisplay.this.getConnection(), PerformanceReportDisplay.this.getToolbar());
                        break;
                    }
                    case SQL: {
                        PerformanceReportDisplay.this.report = new SQLReport(PerformanceReportDisplay.this.getConnection(), PerformanceReportDisplay.this.getToolbar());
                        break;
                    }
                    case DIFF: {
                        PerformanceReportDisplay.this.report = new DiffReport(PerformanceReportDisplay.this.getConnection(), PerformanceReportDisplay.this.getToolbar());
                    }
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PerformanceReportDisplay.this.report.initUI(PerformanceReportDisplay.this.panel);
                            PerformanceReportDisplay.this.panel.revalidate();
                            PerformanceReportDisplay.this.panel.repaint();
                            PerformanceReportDisplay.this.panel.requestFocus();
                            PerformanceReportDisplay.this.isRefreshing = false;
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                PerformanceReportDisplay.this.isRefreshing = false;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                PerformanceReportDisplay.this.isRefreshing = false;
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void clear() {
    }

    public JComponent getUI() {
        if (this.panel == null) {
            this.panel = new JPanel();
        }
        return this.panel;
    }

    public void close() {
        JPanel jPanel = this.panel;
        this.panel = null;
        if (jPanel != null && jPanel.getParent() != null) {
            jPanel.getParent().remove(jPanel);
        }
        super.close();
    }

    public void refresh(boolean bl) {
        if (!this.isRefreshing) {
            this.init();
        }
    }

    public void addActions(List<ObjectAction> list) {
    }

    public void handleToolbarEvent(IdeAction ideAction) {
        String string = Ide.findCmdName((int)ideAction.getCommandId());
        if (string != null) {
            if (string.equals("DbaNavigator.TOGGLE_INPUT")) {
                this.report.toggleInputs();
            } else if (string.equals("DbaNavigator.GENERATE_REPORT")) {
                this.report.generateReport();
            } else if (string.equals("DbaNavigator.SAVE_TO_FILE")) {
                this.report.saveToFile();
            } else if (string.equals("DbaNavigator.OPEN_IN_BROWSER")) {
                this.report.openInBrowser();
            }
        }
    }

    public void updateToolbar(IdeAction ideAction) {
        if (null == this.report) {
            return;
        }
        String string = Ide.findCmdName((int)ideAction.getCommandId());
        if (string != null) {
            if (string != null && string.equals("DbaNavigator.TOGGLE_INPUT")) {
                ideAction.setEnabled(this.report.canToggleInputs());
            } else if (string.equals("DbaNavigator.GENERATE_REPORT")) {
                ideAction.setEnabled(this.report.canGenerateReport());
            } else if (string.equals("DbaNavigator.SAVE_TO_FILE")) {
                ideAction.setEnabled(this.report.canSaveToFile());
            } else if (string.equals("DbaNavigator.OPEN_IN_BROWSER")) {
                ideAction.setEnabled(this.report.canOpenInBrowser());
            }
        }
    }

    public boolean isUseEditorScrollPane() {
        return false;
    }

    public boolean isUseScrollableUI() {
        return false;
    }

    public static enum Type {
        ASH,
        AWR,
        SQL,
        DIFF;

    }
}

