/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.users;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class GrantRoleAction
extends ActionDialog {
    private static final String ROLENAME = "RoleName";
    private static final String ADMIN = "Admin";
    private static final String DEFAULT = "Default";
    private ArrayList<String> _defaultRoles = new ArrayList();

    protected String getTitle() {
        return DbaNavigatorResources.getString("GRANT_ROLE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        String string = this.getObjectName();
        this.loadDefaultRoles(connection, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        SqlComboBoxActionControl sqlComboBoxActionControl = new SqlComboBoxActionControl(ROLENAME, DbaNavigatorResources.getString("ROLE_NAME_LABEL"), connection, this.getQuery(connection, "getGrantableRoles"), hashMap, null);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(ADMIN, DbaNavigatorResources.getString("ROLE_IS_ADMIN_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(DEFAULT, DbaNavigatorResources.getString("ROLE_IS_DEFAULT_LABEL"), true);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)sqlComboBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultRoles(Connection connection, String string) {
        block8: {
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("USERNAME", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getDefaultRoles"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this._defaultRoles.add(resultSet.getString("GRANTED_ROLE"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GRANT \"");
        stringBuffer.append(values.get(ROLENAME));
        stringBuffer.append("\" TO \"");
        stringBuffer.append(this.getObjectName());
        stringBuffer.append("\"");
        if (Boolean.parseBoolean(values.get(ADMIN))) {
            stringBuffer.append("\nWITH ADMIN OPTION");
        }
        boolean bl = Boolean.parseBoolean(values.get(DEFAULT));
        stringBuffer.append(";\nALTER USER \"");
        stringBuffer.append(this.getObjectName());
        stringBuffer.append("\"\nDEFAULT ROLE ");
        boolean bl2 = true;
        if (bl) {
            stringBuffer.append("\"");
            stringBuffer.append(values.get(ROLENAME));
            stringBuffer.append("\"");
            bl2 = false;
        }
        for (String string : this._defaultRoles) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }
}

