/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.users;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ObjectOperationDialog;
import oracle.dbtools.raptor.utils.Connections;

public class DropUserAction
extends ObjectOperationDialog {
    private boolean shardDDLEnabled = false;
    private boolean shardedUser = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet = null;
            try {
                if (connection.getMetaData().getDatabaseMajorVersion() >= 12 && connection.getMetaData().getDatabaseMinorVersion() > 1) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", this.getObjectName());
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getShardedUser"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.shardedUser = resultSet.getString("ALL_SHARD").equals("YES");
                            this.shardDDLEnabled = resultSet.getString("SHARD_DDL_STATUS").equals("ENABLED");
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
            }
        }
        return super.createControls(connection);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("DROP_USER_TITLE");
    }

    protected String getObjectLabel() {
        return DbaNavigatorResources.getString("USER_NAME_LABEL");
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.shardedUser != this.shardDDLEnabled) {
            if (this.shardedUser) {
                stringBuffer.append("ALTER SESSION ENABLE SHARD DDL;\n");
            } else {
                stringBuffer.append("ALTER SESSION DISABLE SHARD DDL;\n");
            }
        }
        stringBuffer.append("DROP USER \"");
        stringBuffer.append(this.getObjectName());
        stringBuffer.append("\" CASCADE");
        if (this.shardedUser != this.shardDDLEnabled) {
            if (this.shardedUser) {
                stringBuffer.append(";\nALTER SESSION DISABLE SHARD DDL;\n");
            } else {
                stringBuffer.append(";\nALTER SESSION ENABLE SHARD DDL;\n");
            }
        }
        return stringBuffer.toString();
    }
}

