/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class DropTablepsaceAction
extends ActionDialog {
    private static final String TABLESPACE = "Tablespace";
    private static final String INCLUDE_CONTENTS = "IncludeContents";
    private static final String INCLUDE_DATAFILES = "IncludeDataFiles";
    private static final String CASCADE = "CascadeConstraints";

    protected String getTitle() {
        return DbaNavigatorResources.getString("DROP_TABLESPACE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(INCLUDE_CONTENTS, DbaNavigatorResources.getString("INCLUDE_CONTENTS_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(INCLUDE_DATAFILES, DbaNavigatorResources.getString("INCLUDE_DATAFILES_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = new BooleanCheckBoxActionControl(CASCADE, DbaNavigatorResources.getString("CASCADE_CONSTRAINTS_LABEL"), false);
        textBoxActionControl.enableUI(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLESPACE \"");
        stringBuffer.append(values.get(TABLESPACE));
        stringBuffer.append("\"");
        if (Boolean.parseBoolean(values.get(INCLUDE_CONTENTS)) && Boolean.parseBoolean(values.get(INCLUDE_DATAFILES))) {
            stringBuffer.append("\n    INCLUDING CONTENTS AND DATAFILES");
        } else if (Boolean.parseBoolean(values.get(INCLUDE_CONTENTS)) && !Boolean.parseBoolean(values.get(INCLUDE_DATAFILES))) {
            stringBuffer.append("\n    INCLUDING CONTENTS");
        } else if (!Boolean.parseBoolean(values.get(INCLUDE_CONTENTS)) && Boolean.parseBoolean(values.get(INCLUDE_DATAFILES))) {
            stringBuffer.append("\n    INCLUDING DATAFILES");
        }
        if (Boolean.parseBoolean(values.get(CASCADE))) {
            stringBuffer.append("\n     CASCADE CONSTRAINTS");
        }
        return stringBuffer.toString();
    }
}

