/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.redologgroups;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateGroupAction
extends ActionDialog {
    private static final String GROUP_NO = "GroupNo";
    private static final String MEMBERS = "Members";
    private static final String FILE_SIZE = "FileSize";

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_GROUP_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        String string;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        long l;
        ArrayList<PathRow> arrayList;
        long l2;
        block23: {
            HashSet<Long> hashSet;
            String string2;
            Operation operation;
            block22: {
                if (DbaUtil.isPDB(connection)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("NOT_SUPPORTED_FOR_PDB"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
                    throw new RuntimeException("not supported for pluggable database");
                }
                operation = this.getOperation();
                string2 = this.getObjectName();
                hashSet = new HashSet<Long>();
                if (Connections.getInstance().lock(connection)) {
                    ResultSet resultSet = null;
                    try {
                        HashMap hashMap = new HashMap();
                        DBUtil dBUtil2 = DBUtil.getInstance((Connection)connection);
                        dBUtil2.setRaiseError(true);
                        resultSet = dBUtil2.executeOracleQuery(this.getQuery(connection, "getLogGroups"), hashMap);
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                long l3 = resultSet.getLong("GROUP#");
                                hashSet.add(l3);
                            }
                        }
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        break block22;
                    }
                    finally {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
            l2 = -1L;
            long l4 = 1L;
            while (l2 < 0L) {
                if (hashSet.contains(l4)) {
                    ++l4;
                    continue;
                }
                l2 = l4;
            }
            arrayList = new ArrayList<PathRow>();
            l = 100L;
            if (operation == Operation.CREATE_NEW) {
                arrayList.add(new PathRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") + "/", DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")));
            } else if (Connections.getInstance().lock(connection)) {
                object = null;
                try {
                    textBoxActionControl = new HashMap();
                    textBoxActionControl.put("GROUPNO", string2.substring(1));
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getLogMembers"), (Map)textBoxActionControl);
                    if (object != null) {
                        while (object.next()) {
                            string = object.getString("MEMBER");
                            int n = string.lastIndexOf(47);
                            if (n < 0) {
                                n = string.lastIndexOf(92);
                            }
                            n = n < 0 ? 0 : ++n;
                            String string3 = string.substring(0, n);
                            arrayList.add(new PathRow(string3, DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")));
                            l = object.getLong("NUM_BLOCKS");
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block23;
                }
                finally {
                    DBUtil.closeResultSet(object);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        object = new ArrayList<String>();
        ((ArrayList)object).add(DbaNavigatorResources.getString("DIRECTORY_LABEL"));
        ((ArrayList)object).add(DbaNavigatorResources.getString("FILE_NAME_LABEL"));
        textBoxActionControl = new TextBoxActionControl(GROUP_NO, DbaNavigatorResources.getString("GROUP_LABEL"), Long.toString(l2), TextBoxActionControl.getIntegerFormat());
        dBUtil = new TableActionControl(MEMBERS, DbaNavigatorResources.getString("MEMBERS_LABEL"), (TableActionControl.RowFactory)new PathRowFactory(), (List)object, arrayList, 3);
        string = new FileSizeActionControl(FILE_SIZE, DbaNavigatorResources.getString("FILE_SIZE_LABEL"), l * 1024L);
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        arrayList2.add((ActionControl)textBoxActionControl);
        arrayList2.add((ActionControl)dBUtil);
        arrayList2.add((ActionControl)string);
        return arrayList2;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER DATABASE\nADD LOGFILE GROUP " + values.get(GROUP_NO));
        stringBuffer.append(" (");
        List list = values.getList(MEMBERS, DbaNavigatorResources.getString("DIRECTORY_LABEL"));
        List list2 = values.getList(MEMBERS, DbaNavigatorResources.getString("FILE_NAME_LABEL"));
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append('\'');
            } else {
                stringBuffer.append(", '");
            }
            stringBuffer.append((String)list.get(i));
            stringBuffer.append((String)list2.get(i));
            stringBuffer.append('\'');
        }
        stringBuffer.append(")\nSIZE ");
        stringBuffer.append(values.get(FILE_SIZE, "SizeClause"));
        return stringBuffer.toString();
    }

    private class PathRow
    implements TableActionControl.Row {
        private String[] _cols;

        PathRow(String string, String string2) {
            this._cols = new String[]{string, string2};
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return true;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class PathRowFactory
    implements TableActionControl.RowFactory {
        private PathRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            PathRow pathRow = null;
            pathRow = row != null ? new PathRow(row.getValue(0), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")) : new PathRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"));
            return pathRow;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE;

    }
}

