/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.dbagraphics;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.FadeTransition;
import javafx.animation.PathTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.javafx.editor.FxQueryViewer;
import oracle.dbtools.raptor.javafx.fxml.FxmlInfo;
import oracle.dbtools.raptor.javafx.fxml.FxmlInfoBuilder;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.jdeveloper.db.ConnectionException;

public class DbaInstanceViewer
extends FxQueryViewer
implements LayoutControl {
    private static final String FXML_FILE = "/oracle/dbtools/raptor/dba/navigator/actions/dbagraphics/ArchiveLogs.fxml";
    private static final String FXML_FILE2 = "/oracle/dbtools/raptor/dba/navigator/actions/dbagraphics/sga.fxml";
    private static final String FXML_FILE3 = "/oracle/dbtools/raptor/dba/navigator/actions/dbagraphics/DbaInstanceViewer.fxml";
    private static final String FXML_FILE4 = "/oracle/dbtools/raptor/dba/navigator/actions/dbagraphics/TopActivity.fxml";
    private static final String RESOURCE_BUNDLE = "oracle.dbtools.raptor.dba.navigator.actions.dbagraphics.ArchiveLogsArb";
    private Timer timer;
    private static final long DELAY_TIME_MS = 2500L;
    private static final int NUM_CHARTS = 4;
    private TranslateTransition redTranslateTransition;
    private FadeTransition redFadeTransition;
    private FadeTransition greenFadeTransition;
    private PathTransition pathTransition;

    public void openImpl(boolean bl) {
        super.openImpl(bl);
        try {
            String string = Connections.getInstance().createPrivateConnection(this.getFqConnectionName());
            this.setFqConnectionName(string);
        }
        catch (ConnectionException connectionException) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)connectionException);
        }
    }

    public void closeImpl(boolean bl) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        super.closeImpl(bl);
    }

    protected Scene createSceneImpl() {
        Scene scene = null;
        return scene;
    }

    private void initTabRamesh3(Tab tab) {
        try {
            FxmlInfo fxmlInfo = FxmlInfoBuilder.create().fxmlFile(FXML_FILE).resourceBundle(RESOURCE_BUNDLE).classLoader(((Object)((Object)this)).getClass().getClassLoader()).build();
            this.add(fxmlInfo);
            fxmlInfo.setConnection(this.getFqConnectionName());
            tab.setContent((Node)fxmlInfo.getFxmlUI());
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    private void initTabSga(Tab tab) {
        try {
            FxmlInfo fxmlInfo = FxmlInfoBuilder.create().fxmlFile(FXML_FILE2).resourceBundle(RESOURCE_BUNDLE).classLoader(((Object)((Object)this)).getClass().getClassLoader()).build();
            this.add(fxmlInfo);
            fxmlInfo.setConnection(this.getFqConnectionName());
            tab.setContent((Node)fxmlInfo.getFxmlUI());
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    private void initTabInstanceViewer(Tab tab) {
        try {
            FxmlInfo fxmlInfo = FxmlInfoBuilder.create().fxmlFile(FXML_FILE3).resourceBundle(RESOURCE_BUNDLE).classLoader(((Object)((Object)this)).getClass().getClassLoader()).build();
            this.add(fxmlInfo);
            fxmlInfo.setConnection(this.getFqConnectionName());
            tab.setContent((Node)fxmlInfo.getFxmlUI());
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    private void initTabTopActivity(Tab tab) {
        try {
            FxmlInfo fxmlInfo = FxmlInfoBuilder.create().fxmlFile(FXML_FILE4).resourceBundle(RESOURCE_BUNDLE).classLoader(((Object)((Object)this)).getClass().getClassLoader()).build();
            this.add(fxmlInfo);
            fxmlInfo.setConnection(this.getFqConnectionName());
            tab.setContent((Node)fxmlInfo.getFxmlUI());
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    private void initTabRamesh1(Tab tab) {
        VBox vBox = new VBox(6.0);
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        gridPane.setVgap(5.0);
        gridPane.setHgap(5.0);
        gridPane.add((Node)this.drawLines(), 10, 10);
        gridPane.add((Node)this.drawShapes(), 20, 10);
        gridPane.add((Node)this.drawSolidCylinder(), 30, 10);
        gridPane.add((Node)this.iconButton(), 10, 20);
        gridPane.add((Node)this.fadeImageRed(), 20, 20);
        gridPane.add((Node)this.fadeImageGreen(), 30, 20);
        gridPane.add((Node)this.progressIndicator(), 10, 30);
        gridPane.add((Node)this.getProgressBar(), 20, 30);
        gridPane.add((Node)this.getNodeDiagram(), 30, 30);
        vBox.getChildren().add((Object)gridPane);
        this.playTab1();
        tab.setContent((Node)vBox);
    }

    private Group drawSolidCylinder() {
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.RED)};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
        Rectangle rectangle = new Rectangle();
        rectangle.setFill((Paint)linearGradient);
        Ellipse ellipse = new Ellipse(100.0, 100.0, 50.0, 10.0);
        ellipse.setStroke((Paint)Color.RED);
        ellipse.setFill(null);
        Ellipse ellipse2 = new Ellipse(100.0, 140.0, 50.0, 10.0);
        ellipse2.setFill((Paint)linearGradient);
        Ellipse ellipse3 = new Ellipse(100.0, 200.0, 50.0, 10.0);
        ellipse3.setFill((Paint)linearGradient);
        Ellipse ellipse4 = new Ellipse(100.0, 140.0, 50.0, 10.0);
        ellipse4.setStroke((Paint)Color.PINK);
        ellipse4.setFill(null);
        Ellipse ellipse5 = new Ellipse(100.0, 200.0, 50.0, 10.0);
        ellipse5.setStroke((Paint)Color.PINK);
        ellipse5.setFill(null);
        Line line = new Line(50.0, 100.0, 50.0, 200.0);
        line.setStroke((Paint)Color.RED);
        Line line2 = new Line(150.0, 100.0, 150.0, 200.0);
        line2.setStroke((Paint)Color.RED);
        Rectangle rectangle2 = new Rectangle(50.0, 140.0, 100.0, 60.0);
        rectangle2.setFill((Paint)linearGradient);
        return new Group(new Node[]{ellipse, ellipse2, ellipse3, line, line2, rectangle2, ellipse4, ellipse5});
    }

    private Group progressIndicator() {
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.setPrefSize(50.0, 50.0);
        return new Group(new Node[]{progressIndicator});
    }

    private Group animatedConnector() {
        Line line = new Line(10.0, 20.0, 190.0, 20.0);
        line.setFill(null);
        line.setStroke((Paint)Color.RED);
        line.setStrokeWidth(5.0);
        Line line2 = new Line(10.0, 20.0, 180.0, 20.0);
        line2.setFill(null);
        line2.setStroke((Paint)Color.DODGERBLUE);
        line2.getStrokeDashArray().setAll((Object[])new Double[]{4.0, 10.0});
        line2.setStrokeWidth(5.0);
        this.redTranslateTransition = new TranslateTransition(Duration.seconds((double)0.5), (Node)line2);
        this.redTranslateTransition.setFromX(10.0);
        this.redTranslateTransition.setToX(20.0);
        this.redTranslateTransition.setCycleCount(-1);
        this.redTranslateTransition.setAutoReverse(true);
        return new Group(new Node[]{line, line2});
    }

    private Group iconButton() {
        Image image = new Image("alertLogActive.png");
        ImageView imageView = new ImageView(image);
        Button button = new Button("Alert Log", (Node)imageView);
        button.setContentDisplay(ContentDisplay.TOP);
        return new Group(new Node[]{button});
    }

    private Group drawLines() {
        Line line = new Line(35.0, 50.0, 180.0, 50.0);
        line.setFill(null);
        line.setStroke((Paint)Color.RED);
        line.setStrokeWidth(5.0);
        Arc arc = new Arc(100.0, 160.0, 45.0, 45.0, 40.0, 100.0);
        arc.setStroke((Paint)Color.BLUE);
        arc.setStrokeWidth(3.0);
        arc.setFill(null);
        Polygon polygon = new Polygon();
        polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 20.0, 10.0, 10.0, 20.0});
        Path path = new Path();
        path.getElements().add((Object)new MoveTo(20.0, 20.0));
        path.getElements().add((Object)new CubicCurveTo(0.0, 100.0, 0.0, 240.0, 280.0, 240.0));
        path.setStroke((Paint)Color.GREEN);
        path.setStrokeWidth(4.0);
        return new Group(new Node[]{line, arc, path});
    }

    private Group drawShapes() {
        Ellipse ellipse = new Ellipse(200.0, 100.0, 50.0, 10.0);
        ellipse.setStroke((Paint)Color.RED);
        ellipse.setFill((Paint)Color.BLUE);
        Polygon polygon = new Polygon();
        polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 20.0, 10.0, 40.0, 0.0, 30.0, 30.0, 10.0, 20.0});
        Circle circle = new Circle();
        circle.setCenterX(100.0);
        circle.setCenterY(200.0);
        circle.setRadius(50.0);
        circle.setFill((Paint)Color.GREEN);
        Rectangle rectangle = new Rectangle(50.0, 50.0, 40.0, 40.0);
        rectangle.setFill((Paint)Color.RED);
        return new Group(new Node[]{rectangle, ellipse, circle, polygon});
    }

    private Group fadeImageRed() {
        Circle circle = new Circle(45.0, 45.0, 20.0);
        circle.setFill((Paint)Color.RED);
        this.redFadeTransition = new FadeTransition(Duration.seconds((double)3.0), (Node)circle);
        this.redFadeTransition.setFromValue(2.0);
        this.redFadeTransition.setToValue((double)0.4f);
        this.redFadeTransition.setCycleCount(-1);
        this.redFadeTransition.setAutoReverse(true);
        return new Group(new Node[]{circle});
    }

    private Group fadeImageGreen() {
        Circle circle = new Circle(45.0, 45.0, 20.0);
        circle.setFill((Paint)Color.GREEN);
        this.greenFadeTransition = new FadeTransition(Duration.seconds((double)3.0), (Node)circle);
        this.greenFadeTransition.setFromValue(2.0);
        this.greenFadeTransition.setToValue((double)0.4f);
        this.greenFadeTransition.setCycleCount(-1);
        this.greenFadeTransition.setAutoReverse(true);
        return new Group(new Node[]{circle});
    }

    private Group getProgressBar() {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setPrefWidth(150.0);
        return new Group(new Node[]{progressBar});
    }

    private Group getNodeDiagram() {
        VBox vBox = new VBox(6.0);
        Label label = this.getText("ChildNode");
        Label label2 = this.getText("Parent");
        Polygon polygon = new Polygon(new double[]{7.5, 0.0, 15.0, 15.0, 7.51, 15.0, 7.51, 40.0, 7.49, 40.0, 7.49, 15.0, 0.0, 15.0});
        polygon.setFill((Paint)Color.WHITE);
        polygon.setStroke((Paint)Color.BLACK);
        Label label3 = new Label("<<extends>>");
        label3.setStyle("-fx-padding: 0 0 0 -1em;");
        vBox.getChildren().addAll((Object[])new Node[]{label2, polygon, label});
        vBox.setAlignment(Pos.CENTER);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(10.0));
        hBox.getChildren().addAll((Object[])new Node[]{vBox, label3});
        return new Group(new Node[]{hBox});
    }

    private Label getText(String string) {
        Label label = new Label(string);
        label.setStyle("-fx-border-color:black; -fx-padding:3px;");
        label.setLayoutX(4.0);
        label.setLayoutY(2.0);
        return label;
    }

    private void initTabRamesh2(Tab tab) {
        VBox vBox = new VBox(6.0);
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        gridPane.setVgap(5.0);
        gridPane.setHgap(0.0);
        gridPane.add((Node)this.drawDBCylinder(), 10, 10);
        gridPane.add((Node)this.connectedLine(), 20, 10);
        gridPane.add((Node)this.getARC(), 30, 10);
        vBox.getChildren().add((Object)gridPane);
        this.playTab2();
        tab.setContent((Node)vBox);
    }

    public Group drawDBCylinder() {
        VBox vBox = new VBox();
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.RED)};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
        Rectangle rectangle = new Rectangle();
        rectangle.setFill((Paint)linearGradient);
        Ellipse ellipse = new Ellipse(100.0, 100.0, 50.0, 10.0);
        ellipse.setStroke((Paint)Color.RED);
        ellipse.setStrokeWidth(2.0);
        ellipse.setFill(null);
        Ellipse ellipse2 = new Ellipse(100.0, 130.0, 50.0, 10.0);
        ellipse2.setFill((Paint)linearGradient);
        ellipse2.setStrokeWidth(2.0);
        Ellipse ellipse3 = new Ellipse(100.0, 170.0, 50.0, 10.0);
        ellipse3.setFill((Paint)linearGradient);
        ellipse3.setStrokeWidth(2.0);
        Ellipse ellipse4 = new Ellipse(100.0, 130.0, 50.0, 10.0);
        ellipse4.setStroke((Paint)Color.PINK);
        ellipse4.setFill(null);
        ellipse4.setStrokeWidth(2.0);
        Ellipse ellipse5 = new Ellipse(100.0, 170.0, 50.0, 10.0);
        ellipse5.setStroke((Paint)Color.PINK);
        ellipse5.setFill(null);
        ellipse5.setStrokeWidth(2.0);
        Line line = new Line(50.0, 100.0, 50.0, 170.0);
        line.setStroke((Paint)Color.RED);
        line.setStrokeWidth(2.0);
        Line line2 = new Line(150.0, 100.0, 150.0, 170.0);
        line2.setStroke((Paint)Color.RED);
        line2.setStrokeWidth(2.0);
        Rectangle rectangle2 = new Rectangle(50.0, 130.0, 100.0, 40.0);
        rectangle2.setFill((Paint)linearGradient);
        rectangle2.setStrokeWidth(2.0);
        Group group = new Group(new Node[]{ellipse, ellipse2, ellipse3, line, line2, rectangle2, ellipse4, ellipse5});
        Label label = new Label("Archieve Logs \n         55%", (Node)group);
        label.setContentDisplay(ContentDisplay.CENTER);
        vBox.getChildren().addAll((Object[])new Node[]{group, label});
        Line line3 = new Line(0.0, 110.0, 100.0, 110.0);
        line3.setStroke((Paint)Color.GREEN);
        line3.setStrokeWidth(3.0);
        Line line4 = new Line(0.0, 110.0, 55.0, 110.0);
        line4.setStroke((Paint)Color.RED);
        line4.setStrokeWidth(5.0);
        return new Group(new Node[]{vBox, line3, line4});
    }

    public Group getARC() {
        HBox hBox = new HBox(10.0);
        Circle circle = new Circle(45.0, 45.0, 10.0);
        circle.setFill((Paint)Color.GREEN);
        this.greenFadeTransition = new FadeTransition(Duration.seconds((double)3.0), (Node)circle);
        this.greenFadeTransition.setFromValue(2.0);
        this.greenFadeTransition.setToValue((double)0.4f);
        this.greenFadeTransition.setCycleCount(-1);
        this.greenFadeTransition.setAutoReverse(true);
        Label label = new Label("ARC");
        TextField textField = new TextField("30");
        textField.setMaxSize(25.0, 20.0);
        hBox.getChildren().addAll((Object[])new Node[]{circle, label, textField});
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(12.0));
        Rectangle rectangle = new Rectangle(0.0, 0.0, 110.0, 50.0);
        rectangle.setArcHeight(10.0);
        rectangle.setArcWidth(10.0);
        rectangle.setStroke((Paint)Color.BLUE);
        rectangle.setStrokeWidth(4.0);
        rectangle.setFill(null);
        return new Group(new Node[]{hBox, rectangle});
    }

    public Group connectedLine() {
        Circle circle = new Circle(20.0, 20.0, 5.0);
        circle.setFill((Paint)Color.GREEN);
        Path path = new Path();
        path.getElements().addAll((Object[])new PathElement[]{new MoveTo(100.0, 100.0), new HLineTo(200.0), new ClosePath()});
        path.setStroke((Paint)Color.BLACK);
        path.setStrokeWidth(3.0);
        this.pathTransition = new PathTransition();
        this.pathTransition.setDuration(Duration.seconds((double)4.0));
        this.pathTransition.setPath((Shape)path);
        this.pathTransition.setNode((Node)circle);
        this.pathTransition.setCycleCount(-1);
        this.pathTransition.setAutoReverse(true);
        return new Group(new Node[]{circle, path});
    }

    private void initTabBrian1(Tab tab) {
        this.timer = new Timer("Timer-" + this.getFqConnectionName());
        VBox vBox = new VBox(6.0);
        for (int i = 1; i <= 4; ++i) {
            SampleTableModel sampleTableModel = new SampleTableModel();
            SampleTableModelTimedUpdater sampleTableModelTimedUpdater = new SampleTableModelTimedUpdater(sampleTableModel, 3000);
            BarChart barChart = this.createBarChart(sampleTableModel, i);
            vBox.getChildren().add((Object)barChart);
            this.timer.schedule((TimerTask)sampleTableModelTimedUpdater, 2500L, 2500L);
        }
        tab.setContent((Node)vBox);
    }

    private BarChart createBarChart(SampleTableModel sampleTableModel, int n) {
        BarChart barChart = null;
        try {
            CategoryAxis categoryAxis = new CategoryAxis(FXCollections.observableArrayList(sampleTableModel.getColumnNames()));
            categoryAxis.setLabel("Year");
            double d = sampleTableModel.getTickUnit();
            NumberAxis numberAxis = new NumberAxis();
            numberAxis.setLabel("Bar Chart " + n);
            numberAxis.setTickUnit(d);
            barChart = new BarChart((Axis)categoryAxis, (Axis)numberAxis, sampleTableModel.getBarChartData());
            barChart.setLegendVisible(false);
            barChart.setPrefHeight(80.0);
            final BarChart barChart2 = barChart;
            sampleTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() == 0) {
                        final int n = tableModelEvent.getFirstRow();
                        final int n2 = tableModelEvent.getColumn();
                        final Object object = ((SampleTableModel)tableModelEvent.getSource()).getValueAt(n, n2);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                XYChart.Series series = (XYChart.Series)barChart2.getData().get(n);
                                XYChart.Data data = (XYChart.Data)series.getData().get(n2);
                                data.setYValue(object);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        return barChart;
    }

    public void playTab1() {
        this.redFadeTransition.play();
        this.greenFadeTransition.play();
    }

    public void stopTab1() {
        this.redFadeTransition.stop();
        this.redFadeTransition.stop();
    }

    public void playTab2() {
        this.greenFadeTransition.play();
        this.pathTransition.play();
    }

    public void stopTab2() {
        this.greenFadeTransition.stop();
        this.pathTransition.stop();
    }

    public static class SampleTableModel
    extends AbstractTableModel {
        private ObservableList<XYChart.Series> bcData;
        private final String[] names = new String[]{"2007", "2008", "2009"};
        private Object[][] data = new Object[][]{{new Double(567.0), new Double(956.0), new Double(1154.0)}, {new Double(1292.0), new Double(1665.0), new Double(1927.0)}, {new Double(1292.0), new Double(2559.0), new Double(2774.0)}};

        public double getTickUnit() {
            return 1000.0;
        }

        public List<String> getColumnNames() {
            return Arrays.asList(this.names);
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Double) {
                this.data[n][n2] = (Double)object;
            }
            this.fireTableCellUpdated(n, n2);
        }

        public ObservableList<XYChart.Series> getBarChartData() {
            if (this.bcData == null) {
                this.bcData = FXCollections.observableArrayList();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    ObservableList observableList = FXCollections.observableArrayList();
                    for (int j = 0; j < this.getColumnCount(); ++j) {
                        observableList.add((Object)new XYChart.Data((Object)this.getColumnName(j), this.getValueAt(i, j)));
                    }
                    this.bcData.add((Object)new XYChart.Series(observableList));
                }
            }
            return this.bcData;
        }
    }

    public static class SampleTableModelTimedUpdater
    extends TimerTask {
        private AbstractTableModel tableModel;
        private Random _random = new Random();
        private int valueMax;
        private int rowCount;
        private int columnCount;

        public SampleTableModelTimedUpdater(AbstractTableModel abstractTableModel, int n) {
            assert (abstractTableModel != null);
            assert (n > 0);
            this.tableModel = abstractTableModel;
            this.valueMax = n;
            this.rowCount = this.tableModel.getRowCount();
            this.columnCount = this.tableModel.getColumnCount();
        }

        @Override
        public void run() {
            try {
                final Double d = this._random.nextDouble() * (double)this.valueMax;
                final int n = this._random.nextInt(this.rowCount);
                final int n2 = this._random.nextInt(this.columnCount);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tableModel.setValueAt(d, n, n2);
                    }
                });
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
        }
    }
}

