/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.datafiles;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ObjectOperationDialog;
import oracle.dbtools.raptor.utils.Connections;

public class OfflineAction
extends ObjectOperationDialog {
    private boolean isTemp;

    protected String getTitle() {
        return DbaNavigatorResources.getString("TAKE_OFFLINE_TITLE");
    }

    protected String getObjectLabel() {
        return DbaNavigatorResources.getString("FILE_NAME_LABEL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        List list;
        block8: {
            list = super.createControls(connection);
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("FILEPATH", this.getObjectName());
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getTablespace"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.isTemp = resultSet.getString("TEMP").equals("YES");
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return list;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTemp) {
            stringBuffer.append("ALTER DATABASE\nTEMPFILE '");
        } else {
            stringBuffer.append("ALTER DATABASE\nDATAFILE '");
        }
        stringBuffer.append(this.getObjectName());
        stringBuffer.append("'\nOFFLINE");
        return stringBuffer.toString();
    }
}

