/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.consumergroupmappings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditPrioritiesAction
extends ActionDialog {
    private static final String SELECTIONS = "SELECTIONS";

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_MAPPING_PRIORITIES");
    }

    protected List<ActionControl> createControls(Connection connection) {
        SelectionActionControl selectionActionControl = new SelectionActionControl(SELECTIONS, null, 2, this.getInitialItems(connection));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)selectionActionControl);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getInitialItems(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getMappingPriorities"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("ATTRIBUTE"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = values.getList(SELECTIONS, "SELECTED_ITEMS");
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SET_CONSUMER_GROUP_MAPPING_PRI(");
        stringBuffer.append("\n        EXPLICIT => 1");
        for (int i = 0; i < list.size(); ++i) {
            int n = i + 2;
            stringBuffer.append(",\n        ");
            stringBuffer.append((String)list.get(i));
            stringBuffer.append(" => ");
            stringBuffer.append(n);
        }
        stringBuffer.append(");\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;");
        return stringBuffer.toString();
    }
}

