/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.consumergroupmappings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.consumergroupmappings.SessionAttrib;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditMappingsAction
extends ActionDialog {
    private static final String GROUP = "GROUP";
    private static final String SELECTIONS = "SELECTIONS";
    private ComboBoxActionControl _groupsCtl;
    private SelectionActionControl _selectionCtl;
    private ArrayList<String> _initialValues;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_COMSUMER_GROUP_MAPPINGS");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        this._groupsCtl = new ComboBoxActionControl(GROUP, DbaNavigatorResources.getString("CONSUMER_GROUP_NAME"), this.toStringArray(this.getConsumerGroups(connection)));
        this._selectionCtl = new SelectionActionControl(SELECTIONS, DbaNavigatorResources.getString("MAPPING_ATTRIB_VALUES"), 1, this.getInitialItems(connection), this.getSourceItems(connection));
        this._groupsCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditMappingsAction.this._selectionCtl.resetListContents(EditMappingsAction.this.getInitialItems(connection), EditMappingsAction.this.getSourceItems(connection));
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)this._groupsCtl);
        arrayList.add((ActionControl)this._selectionCtl);
        return arrayList;
    }

    private String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getConsumerGroups(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getConsumerGroups"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("CONSUMER_GROUP"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getSourceItems(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, SessionAttrib.valueOf(this.getObjectName()).getValuesQueryName()), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("VALUE"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        arrayList.removeAll(this.getInitialItems(connection));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getInitialItems(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            String string = this._groupsCtl.getValue().get();
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("ATTRIBNAME", this.getObjectName());
                    hashMap.put("CONSUMERGROUP", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getAttribValues"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("VALUE"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this._initialValues = arrayList;
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = values.getList(SELECTIONS, "SELECTED_ITEMS");
        if (this._initialValues != null) {
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
            for (String object : this._initialValues) {
                stringBuffer.append("    DBMS_RESOURCE_MANAGER.SET_CONSUMER_GROUP_MAPPING(");
                stringBuffer.append("\n        '");
                stringBuffer.append(this.getObjectName());
                stringBuffer.append("',\n        '");
                stringBuffer.append(object);
                stringBuffer.append("',\n        NULL);\n");
            }
            String string = values.get(GROUP);
            for (String string2 : list) {
                stringBuffer.append("    DBMS_RESOURCE_MANAGER.SET_CONSUMER_GROUP_MAPPING(");
                stringBuffer.append("\n        '");
                stringBuffer.append(this.getObjectName());
                stringBuffer.append("',\n        '");
                stringBuffer.append(string2);
                stringBuffer.append("',\n        '");
                stringBuffer.append(string);
                stringBuffer.append("');\n");
            }
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
            stringBuffer.append("END;");
        }
        return stringBuffer.toString();
    }
}

