/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateCustomBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class CreateArchivedLogsBackupAction
extends CreateCustomBackupAction {
    public static final String DELETION_STRATEGY = "DELETION_STRATEGY";
    public static final String DAYS_UNTIL_DELETION = "DAYS_UNTIL_DELETION";
    public static final String NUMBER_OF_BACKUPS = "NUMBER_OF_BACKUPS";
    public static final String DELETE_IMMEDIATELY = DbaNavigatorResources.getString("DELETE_IMMEDIATELY");
    public static final String DELETE_LATER = DbaNavigatorResources.getString("DELETE_LATER");
    public static final String NEVER_DELETE = DbaNavigatorResources.getString("NEVER_DELETE");
    private RMANScriptProcessorActionControl _getScriptProcessorActionControl;

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_ARCHIVED_LOGS_BACKUP_TITLE");
    }

    @Override
    protected RMANScriptProcessorActionControl getScriptProcessorActionControl() {
        return this._getScriptProcessorActionControl;
    }

    @Override
    protected int getOptionsControlGroupsMask() {
        return 6;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.onCreateControls(connection);
        this._getScriptProcessorActionControl = new RMANScriptProcessorActionControl(connection, "sqldev.rman");
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(DELETION_STRATEGY, DbaNavigatorResources.getString("DELETION_STRATEGY_LABEL"), new String[]{DELETE_IMMEDIATELY, DELETE_LATER, NEVER_DELETE}, DELETE_IMMEDIATELY);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(DAYS_UNTIL_DELETION, DbaNavigatorResources.getString("DAYS_UNTIL_DELETION_LABEL"), "7", TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(NUMBER_OF_BACKUPS, DbaNavigatorResources.getString("NUMBER_OF_BACKUPS_LABEL"), "1", TextBoxActionControl.getIntegerFormat());
        textBoxActionControl.enableUI(false);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl, (ActionControl)comboBoxActionControl){
            final /* synthetic */ ActionControl val$daysCtl;
            final /* synthetic */ ActionControl val$strategyActionCtl;
            {
                this.val$daysCtl = actionControl;
                this.val$strategyActionCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$daysCtl.enableUI(this.val$strategyActionCtl.getValue().get().equals(DELETE_LATER));
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(this._getScriptProcessorActionControl);
        return arrayList;
    }

    public static boolean hasDeletionStrategy(ActionDialog.Lookup lookup) {
        return lookup.get(DELETION_STRATEGY) != null;
    }

    public static boolean isDeleteImmediately(ActionDialog.Lookup lookup) {
        return lookup.get(DELETION_STRATEGY).equals(DELETE_IMMEDIATELY);
    }

    public static boolean isDeleteLater(ActionDialog.Lookup lookup) {
        return lookup.get(DELETION_STRATEGY).equals(DELETE_LATER);
    }

    public static boolean isNeverDelete(ActionDialog.Lookup lookup) {
        return lookup.get(DELETION_STRATEGY).equals(NEVER_DELETE);
    }

    public static boolean hasDaysUntilDeletion(ActionDialog.Lookup lookup) {
        return lookup.get(DAYS_UNTIL_DELETION) != null;
    }

    public static int getDaysUntilDeletion(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(DAYS_UNTIL_DELETION));
    }

    public static boolean hasNumberOfBackups(ActionDialog.Lookup lookup) {
        return lookup.get(NUMBER_OF_BACKUPS) != null;
    }

    public static int getNumberOfBackups(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(NUMBER_OF_BACKUPS));
    }
}

