/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.CalculatedMemberRef;
import oracle.AWXML.Dimension;

public class Model
extends BaseObject {
    private String m_contents = "model";
    private Dimension m_dimension;
    private Vector m_calculatedMember = new Vector(0);

    public Model() {
    }

    public Model(BaseObject baseObject) {
        super(baseObject);
        this.m_dimension = (Dimension)baseObject;
    }

    public void addCalculatedMemberRef(CalculatedMemberRef calculatedMemberRef) {
        this.m_calculatedMember.add(calculatedMemberRef);
        calculatedMemberRef.setOwner(this);
    }

    public void addCalculatedMemberRefAfter(CalculatedMemberRef calculatedMemberRef, BaseObject baseObject) {
        int n;
        if (baseObject instanceof CalculatedMemberRef) {
            n = this.m_calculatedMember.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CALCULATEDMEMBERS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{calculatedMemberRef.getId(), "CALCULATEDMEMBER"});
        }
        this.m_calculatedMember.add(n + 1, calculatedMemberRef);
        calculatedMemberRef.setOwner(this);
    }

    public void addCalculatedMemberRefBefore(CalculatedMemberRef calculatedMemberRef, BaseObject baseObject) {
        int n;
        if (baseObject instanceof CalculatedMemberRef) {
            n = this.m_calculatedMember.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CALCULATEDMEMBERS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{calculatedMemberRef.getId(), "CALCULATEDMEMBER"});
        }
        this.m_calculatedMember.add(n, calculatedMemberRef);
        calculatedMemberRef.setOwner(this);
    }

    public void addCalculatedMemberRefFirst(CalculatedMemberRef calculatedMemberRef) {
        this.m_calculatedMember.add(0, calculatedMemberRef);
        calculatedMemberRef.setOwner(this);
    }

    public void removeCalculatedMemberRef(CalculatedMemberRef calculatedMemberRef) {
        this.m_calculatedMember.remove(calculatedMemberRef);
    }

    public Vector getCalculatedMemberRefs() {
        return this.m_calculatedMember;
    }

    public CalculatedMemberRef createCalculatedMemberRef() {
        CalculatedMemberRef calculatedMemberRef = new CalculatedMemberRef(this);
        this.addCalculatedMemberRef(calculatedMemberRef);
        calculatedMemberRef.setName("CalcMbrRef" + this.m_calculatedMember.size());
        return calculatedMemberRef;
    }

    public CalculatedMemberRef createCalculatedMemberRefAfter(CalculatedMemberRef calculatedMemberRef) {
        CalculatedMemberRef calculatedMemberRef2 = new CalculatedMemberRef(this);
        this.addCalculatedMemberRefAfter(calculatedMemberRef2, calculatedMemberRef);
        calculatedMemberRef2.setName("CalcMbrRef" + this.m_calculatedMember.size());
        return calculatedMemberRef2;
    }

    public CalculatedMemberRef createCalculatedMemberRefBefore(CalculatedMemberRef calculatedMemberRef) {
        CalculatedMemberRef calculatedMemberRef2 = new CalculatedMemberRef(this);
        this.addCalculatedMemberRefBefore(calculatedMemberRef2, calculatedMemberRef);
        calculatedMemberRef2.setName("CalcMbrRef" + this.m_calculatedMember.size());
        return calculatedMemberRef2;
    }

    public CalculatedMemberRef createCalculatedMemberRefFirst() {
        CalculatedMemberRef calculatedMemberRef = new CalculatedMemberRef(this);
        this.addCalculatedMemberRefFirst(calculatedMemberRef);
        calculatedMemberRef.setName("CalcMbrRef" + this.m_calculatedMember.size());
        return calculatedMemberRef;
    }

    public String WriteToXML() {
        String string = null;
        string = Model.TAB() + this.WriteElementStart("Model");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Model.TAB() + this.WriteElementEndTag("Model") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string + this.WriteAsAttribute("contents", this.m_contents);
        return string;
    }

    public String WriteContentsToXML() {
        ++s_Indent;
        String string = super.WriteContentsToXML();
        if (this.m_owner != null) {
            string = string == null ? this.WriteAsIDRef("Dimension", this.m_owner) : string + this.WriteAsIDRef("Dimension", this.m_owner);
        }
        Iterator iterator = this.m_calculatedMember.iterator();
        while (iterator.hasNext()) {
            CalculatedMemberRef calculatedMemberRef = (CalculatedMemberRef)iterator.next();
            if (string == null) {
                string = calculatedMemberRef.WriteToXML();
                continue;
            }
            string = string + calculatedMemberRef.WriteToXML();
        }
        --s_Indent;
        return string;
    }

    public String getContents() {
        return this.m_contents;
    }

    public void setContents(String string) {
        this.m_contents = string;
    }

    public Dimension getDimension() {
        return this.m_dimension;
    }

    public void setDimension(Dimension dimension) {
        this.m_dimension = dimension;
    }

    public String getAggregationText() {
        return "Model " + this.m_name + "/n";
    }

    public String Create(AWConnection aWConnection) {
        String string = "success";
        if (this.m_dimension != null) {
            String string2 = aWConnection.executeCommand("call create_model(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + AWConnection.CommitMode + ")");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-600000", new Object[]{this.getId(), this.m_commandResultText});
            }
            Iterator iterator = this.m_calculatedMember.iterator();
            while (iterator.hasNext()) {
                CalculatedMemberRef calculatedMemberRef = (CalculatedMemberRef)iterator.next();
                calculatedMemberRef.Create(aWConnection);
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-600002", new Object[]{this.getId()});
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "success";
        String string2 = aWConnection.executeCommand("call delete_model(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-600001", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }
}

