/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.DimensionKeySourceExpression;
import oracle.AWXML.HierarchicalParentSourceExpression;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Level;
import oracle.AWXML.MappingGroup;

public class DimensionMapGroup
extends MappingGroup {
    protected DimensionKeySourceExpression m_keyMap;
    protected HierarchicalParentSourceExpression m_parentMap;
    protected Vector m_attributeMaps = new Vector(0);
    protected String m_type = "HIERARCHYLEVEL";

    protected DimensionMapGroup() {
    }

    public DimensionMapGroup(BaseObject baseObject) {
        super(baseObject);
    }

    public void setType(String string) {
        if (string.equalsIgnoreCase("DIMENSION") || string.equalsIgnoreCase("LEVEL") || string.equalsIgnoreCase("HIERARCHY") || string.equalsIgnoreCase("HIERARCHYLEVEL") || string.equalsIgnoreCase("CUBE")) {
            this.m_type = string.toUpperCase();
        }
    }

    public String WriteToXML() {
        String string = null;
        string = DimensionMapGroup.TAB() + this.WriteElementStart("DimensionMapGroup");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + DimensionMapGroup.TAB() + this.WriteElementEndTag("DimensionMapGroup") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string == null ? this.WriteAsAttribute("Type", this.m_type) : string + this.WriteAsAttribute("Type", this.m_type);
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        if (this.m_keyMap != null) {
            string = string == null ? this.m_keyMap.WriteToXML() : string + this.m_keyMap.WriteToXML();
        }
        if (this.m_parentMap != null) {
            string = string == null ? this.m_parentMap.WriteToXML() : string + this.m_parentMap.WriteToXML();
        }
        Iterator iterator = this.m_attributeMaps.iterator();
        while (iterator.hasNext()) {
            AttributeSourceExpression attributeSourceExpression = (AttributeSourceExpression)iterator.next();
            if (string == null) {
                string = attributeSourceExpression.WriteToXML();
                continue;
            }
            string = string + attributeSourceExpression.WriteToXML();
        }
        return string;
    }

    public DimensionKeySourceExpression getKeyMap() {
        return this.m_keyMap;
    }

    public void setKeyMap(DimensionKeySourceExpression dimensionKeySourceExpression) {
        this.m_keyMap = dimensionKeySourceExpression;
    }

    public void setDimensionKeySourceExpression(DimensionKeySourceExpression dimensionKeySourceExpression) {
        this.m_keyMap = dimensionKeySourceExpression;
    }

    public HierarchicalParentSourceExpression getParentMap() {
        return this.m_parentMap;
    }

    public void setParentMap(HierarchicalParentSourceExpression hierarchicalParentSourceExpression) {
        this.m_parentMap = hierarchicalParentSourceExpression;
    }

    public void setHierarchicalParentSourceExpression(HierarchicalParentSourceExpression hierarchicalParentSourceExpression) {
        this.m_parentMap = hierarchicalParentSourceExpression;
    }

    public void addAttributeMap(AttributeSourceExpression attributeSourceExpression) {
        this.m_attributeMaps.add(attributeSourceExpression);
        attributeSourceExpression.setOwner(this);
    }

    public void removeAttributeMap(AttributeSourceExpression attributeSourceExpression) {
        this.m_attributeMaps.remove(attributeSourceExpression);
    }

    public void addAttributeSourceExpression(AttributeSourceExpression attributeSourceExpression) {
        this.m_attributeMaps.add(attributeSourceExpression);
        attributeSourceExpression.setOwner(this);
    }

    public Vector getAttributeMaps() {
        return this.m_attributeMaps;
    }

    public DimensionKeySourceExpression CreateKeyMap() {
        DimensionKeySourceExpression dimensionKeySourceExpression = new DimensionKeySourceExpression(this);
        this.setKeyMap(dimensionKeySourceExpression);
        dimensionKeySourceExpression.setName("KeyMap");
        if (this.m_owner != null) {
            if (this.m_owner instanceof Hierarchy) {
                dimensionKeySourceExpression.setHierarchy((Hierarchy)this.m_owner);
            }
            if (this.m_owner instanceof Level) {
                dimensionKeySourceExpression.setLevel((Level)this.m_owner);
            }
            if (this.m_owner instanceof HierarchyLevelAssociation) {
                dimensionKeySourceExpression.setLevel(((HierarchyLevelAssociation)this.m_owner).getLevel());
                dimensionKeySourceExpression.setHierarchy((Hierarchy)this.m_owner.getOwner());
            }
        }
        return dimensionKeySourceExpression;
    }

    public HierarchicalParentSourceExpression CreateParentMap() {
        HierarchicalParentSourceExpression hierarchicalParentSourceExpression = new HierarchicalParentSourceExpression(this);
        this.setParentMap(hierarchicalParentSourceExpression);
        hierarchicalParentSourceExpression.setName("PrntMap");
        if (this.m_owner != null) {
            if (this.m_owner instanceof Hierarchy) {
                hierarchicalParentSourceExpression.setHierarchy((Hierarchy)this.m_owner);
            }
            if (this.m_owner instanceof Level) {
                hierarchicalParentSourceExpression.setLevel((Level)this.m_owner);
            }
            if (this.m_owner instanceof HierarchyLevelAssociation) {
                hierarchicalParentSourceExpression.setLevel(((HierarchyLevelAssociation)this.m_owner).getLevel());
                hierarchicalParentSourceExpression.setHierarchy((Hierarchy)this.m_owner.getOwner());
            }
        }
        return hierarchicalParentSourceExpression;
    }

    public AttributeSourceExpression CreateAttributeMap() {
        AttributeSourceExpression attributeSourceExpression = null;
        attributeSourceExpression = AW.getCurAW().getMetaDataFormat() <= 10.1 ? new AttributeSourceExpression(this) : new AttributeSourceExpression(this, AW.getCurAW().getDefaultLanguage());
        this.addAttributeMap(attributeSourceExpression);
        attributeSourceExpression.setName("AttrMap" + this.m_attributeMaps.size());
        if (this.m_owner != null) {
            if (this.m_owner instanceof Hierarchy) {
                attributeSourceExpression.setHierarchy((Hierarchy)this.m_owner);
            }
            if (this.m_owner instanceof Level) {
                attributeSourceExpression.setLevel((Level)this.m_owner);
            }
            if (this.m_owner instanceof HierarchyLevelAssociation) {
                attributeSourceExpression.setLevel(((HierarchyLevelAssociation)this.m_owner).getLevel());
                attributeSourceExpression.setHierarchy((Hierarchy)this.m_owner.getOwner());
            }
        }
        return attributeSourceExpression;
    }

    public AttributeSourceExpression CreateAttributeMap(String string) {
        AttributeSourceExpression attributeSourceExpression = null;
        if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            throw new AWException("Current AW does not have multi-lingual support");
        }
        attributeSourceExpression = new AttributeSourceExpression(this, string);
        this.addAttributeMap(attributeSourceExpression);
        attributeSourceExpression.setName("AttrMap" + this.m_attributeMaps.size());
        if (this.m_owner != null) {
            if (this.m_owner instanceof Hierarchy) {
                attributeSourceExpression.setHierarchy((Hierarchy)this.m_owner);
            }
            if (this.m_owner instanceof Level) {
                attributeSourceExpression.setLevel((Level)this.m_owner);
            }
            if (this.m_owner instanceof HierarchyLevelAssociation) {
                attributeSourceExpression.setLevel(((HierarchyLevelAssociation)this.m_owner).getLevel());
                attributeSourceExpression.setHierarchy((Hierarchy)this.m_owner.getOwner());
            }
        }
        return attributeSourceExpression;
    }

    public String Create(AWConnection aWConnection) {
        String string = "Success";
        aWConnection.executeCommand("call create_mapping_group(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_type) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-400000", new Object[]{this.getId(), this.m_commandResultText});
        }
        if (this.getKeyMap() != null) {
            this.getKeyMap().Create(aWConnection);
        }
        if (this.getParentMap() != null) {
            this.getParentMap().Create(aWConnection);
        }
        Iterator iterator = this.getAttributeMaps().iterator();
        while (iterator.hasNext()) {
            AttributeSourceExpression attributeSourceExpression = (AttributeSourceExpression)iterator.next();
            attributeSourceExpression.Create(aWConnection);
        }
        return string;
    }
}

