/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.DerivedMeasureInput;
import oracle.AWXML.Dimension;

public class Attribute
extends BaseObject
implements DerivedMeasureInput {
    private String m_dataType = "Text";
    private Boolean m_installAsRelation = new Boolean(false);
    private Dimension m_domain;
    private String m_classification = "USER";
    private boolean m_isDefaultOrder = false;
    private boolean m_isMultiLingual = false;

    protected Attribute() {
    }

    public Attribute(BaseObject baseObject) {
        super(baseObject);
    }

    protected Attribute(String string, String string2) {
        super(string, string2);
    }

    public void setDimensionDomain(Dimension dimension) {
        this.m_domain = dimension;
    }

    public Dimension getDimensionDomain() {
        return this.m_domain;
    }

    public void setInstallAsRelation(Boolean bl) {
        this.m_installAsRelation = bl;
    }

    protected Boolean installAsRelation() {
        return this.m_installAsRelation;
    }

    public void setClassification(String string) {
        if (string.equalsIgnoreCase("DEFAULT_ORDER") || string.equalsIgnoreCase("END_DATE") || string.equalsIgnoreCase("TIME_SPAN") || string.equalsIgnoreCase("MEMBER_LONG_DESCRIPTION") || string.equalsIgnoreCase("MEMBER_SHORT_DESCRIPTION") || string.equalsIgnoreCase("MEMBER_VISIBLE") || string.equalsIgnoreCase("USER")) {
            this.m_classification = string;
            if (this.m_classification.equalsIgnoreCase("MEMBER_LONG_DESCRIPTION") || this.m_classification.equalsIgnoreCase("MEMBER_SHORT_DESCRIPTION")) {
                this.m_isMultiLingual = true;
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-210002", new Object[]{this.getId(), string});
        }
    }

    public String getClassification() {
        return this.m_classification;
    }

    public void setDataType(String string) {
        if (!(string.equalsIgnoreCase("TEXT") || string.equalsIgnoreCase("NTEXT") || string.equalsIgnoreCase("ID") || string.equalsIgnoreCase("INTEGER") || string.equalsIgnoreCase("SHORTINTEGER") || string.equalsIgnoreCase("LONGINTEGER") || string.equalsIgnoreCase("DECIMAL") || string.equalsIgnoreCase("SHORTDECIMAL") || string.equalsIgnoreCase("SHORT") || string.equalsIgnoreCase("LONG") || string.equalsIgnoreCase("NUMBER") || string.equalsIgnoreCase("BOOLEAN") || string.equalsIgnoreCase("DATETIME") || string.equalsIgnoreCase("DATE"))) {
            throw new AWException("AWXML-ERR-NUM-210003", new Object[]{this.getId(), string});
        }
        this.m_dataType = string;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public String WriteToXML() {
        String string = null;
        string = Attribute.TAB() + this.WriteElementStart("Attribute");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Attribute.TAB() + this.WriteElementEndTag("Attribute") + s_NEWLINE;
        }
        return string;
    }

    protected String WriteAttributesToXML() {
        String string = null;
        string = super.WriteAttributesToXML();
        string = string + this.WriteAsAttribute("DataType", this.m_dataType);
        string = string + this.WriteAsAttribute("Classification", this.m_classification);
        string = string + this.WriteAsAttribute("InstallAsRelation", this.m_installAsRelation.toString());
        string = string + this.WriteAsAttribute("IsDefaultOrder", new Boolean(this.m_isDefaultOrder).toString());
        if (this.m_isMultiLingual) {
            string = string + this.WriteAsAttribute("IsMultiLingual", new Boolean(this.m_isMultiLingual).toString());
        }
        return string;
    }

    protected String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        if (this.m_domain != null) {
            string = string == null ? this.WriteAsIDRef("DimensionDomain", this.m_domain) : string + this.WriteAsIDRef("DimensionDomain", this.m_domain);
        }
        return string;
    }

    public boolean isDefaultOrder() {
        return this.m_isDefaultOrder;
    }

    public void setIsDefaultOrder(boolean bl) {
        this.m_isDefaultOrder = bl;
    }

    public void setIsDefaultOrder(Boolean bl) {
        this.m_isDefaultOrder = bl;
    }

    public String Create(AWConnection aWConnection) {
        String string;
        String string2;
        if (this.m_domain != null) {
            String string3 = "'RELATION'";
            string2 = this.quoteValue(this.m_domain.getId());
            string = AWNULL;
        } else {
            String string4 = this.quoteValue(this.m_dataType);
            string2 = this.quoteValue(this.m_dataType);
            string = this.m_isMultiLingual || this.m_classification.equalsIgnoreCase("MEMBER_LONG_DESCRIPTION") || this.m_classification.equalsIgnoreCase("MEMBER_SHORT_DESCRIPTION") ? "true" : "false";
        }
        String string5 = "'NO'";
        if (this.m_isDefaultOrder) {
            string5 = "'YES'";
        }
        String string6 = aWConnection.executeCommand("call create_attribute(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + this.quoteValue(this.getClassification()) + "," + string2 + "," + string5 + "," + string + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-210000", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public String Alter(AWConnection aWConnection) {
        String string;
        String string2;
        if (this.m_domain != null) {
            String string3 = "'RELATION'";
            string2 = this.quoteValue(this.m_domain.getId());
            string = AWNULL;
        } else {
            String string4 = this.quoteValue(this.m_dataType);
            string2 = this.quoteValue(this.m_dataType);
            string = this.m_isMultiLingual || this.m_classification.equalsIgnoreCase("MEMBER_LONG_DESCRIPTION") || this.m_classification.equalsIgnoreCase("MEMBER_SHORT_DESCRIPTION") ? "true" : "false";
        }
        String string5 = "'NO'";
        if (this.m_isDefaultOrder) {
            string5 = "'YES'";
        }
        String string6 = aWConnection.executeCommand("call alter_attribute(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + this.quoteValue(this.getClassification()) + "," + string2 + "," + string5 + "," + string + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-210004", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        String string = aWConnection.executeCommand("call delete_attribute(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-210001", new Object[]{this.getId(), this.m_commandResultText});
        }
        if (this.m_owner != null) {
            ((Dimension)this.m_owner).removeAttribute(this);
        }
        return "success";
    }

    protected String Rename(AWConnection aWConnection, String string) {
        try {
            String string2 = aWConnection.getPhysicalObjectName("ATTRDEF", this.getName(), this.getNamePart(1, this.getId()));
            aWConnection.executeCommand("rename " + string2 + " " + string);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return "success";
    }

    protected String getTopLevelParentName() {
        String string = this.m_id.substring(this.m_id.indexOf(".") + 1);
        string = string.substring(0, string.indexOf("."));
        return string;
    }

    public void setIsMultiLingual(Boolean bl) {
        this.m_isMultiLingual = bl;
    }

    public void setIsMultiLingual(boolean bl) {
        this.m_isMultiLingual = bl;
    }

    public boolean isMultiLingual() {
        return this.m_isMultiLingual;
    }
}

