/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import oracle.security.pki.CompositeFileLock;
import oracle.security.pki.OraclePKIDebug;

public class FileLockProvider {
    private static final Map<String, CompositeFileLock> b = new ConcurrentHashMap<String, CompositeFileLock>();
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static int c = Integer.getInteger("oracle.pki.wallet.lockwaitperiod", 60);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileLock a(File file, FileChannel fileChannel, FileInputStream fileInputStream) throws IOException {
        FileLock fileLock = null;
        Map<String, CompositeFileLock> map = b;
        synchronized (map) {
            try {
                OraclePKIDebug.a("Thread with ID:" + Thread.currentThread().getId() + " is trying to acquire JVM-wide shared file lock on physical file with path " + file.getCanonicalPath());
                fileLock = FileLockProvider.a(file, fileChannel, 0L, file.length(), true);
                if (fileLock == null || !fileLock.isValid()) {
                    throw new IOException(a.getString("PKI-02012") + file.getCanonicalPath());
                }
                OraclePKIDebug.a("Thread with ID:" + Thread.currentThread().getId() + " successfully acquire JVM-wide shared file lock on physical file with path " + file.getCanonicalPath());
                CompositeFileLock compositeFileLock = new CompositeFileLock(fileLock, fileChannel, fileInputStream);
                compositeFileLock.a();
                b.put(file.getCanonicalPath(), compositeFileLock);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                OraclePKIDebug.a("Thread with ID:" + Thread.currentThread().getId() + " could not acquire JVM-wide shared file lock on physical file with path " + file.getCanonicalPath() + " as JVM already had lock on the file.");
                CompositeFileLock compositeFileLock = b.get(file.getCanonicalPath());
                compositeFileLock.a();
            }
        }
        return fileLock;
    }

    static FileLock a(File file, FileChannel fileChannel, long l, long l2, boolean bl) throws IOException {
        OraclePKIDebug.a("FileLockProvider.tryLock() : enter");
        FileLock fileLock = null;
        for (int i = 0; i < c * 10 && (fileLock = fileChannel.tryLock(l, l2, bl)) == null; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (fileLock == null) {
            if (file != null) {
                throw new IOException("Lock could not be acquired on " + file.getPath());
            }
            throw new IOException("Lock could not be acquired.");
        }
        OraclePKIDebug.a("FileLockProvider.tryLock() : exit");
        return fileLock;
    }

    static FileLock a(File file, FileChannel fileChannel) throws IOException {
        return FileLockProvider.a(file, fileChannel, 0L, Long.MAX_VALUE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(File file) throws IOException {
        Map<String, CompositeFileLock> map = b;
        synchronized (map) {
            CompositeFileLock compositeFileLock = b.get(file.getCanonicalPath());
            if (compositeFileLock != null) {
                compositeFileLock.b();
                if (compositeFileLock.c() == 0) {
                    FileLock fileLock = compositeFileLock.d();
                    fileLock.release();
                    compositeFileLock.e().close();
                    compositeFileLock.f().close();
                    b.remove(file.getCanonicalPath());
                    OraclePKIDebug.a("Thread with ID:" + Thread.currentThread().getId() + " removed the cached FileLock, FileChannel and FileInputStream objects corresponding to the file-path " + file.getCanonicalPath() + " from class level pool as no reader thread was reading the physical file.");
                }
            }
        }
    }
}

