/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionDescriptorDimensionArgument;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedMetadataObjectReference;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;
import oracle.olapi.syntax.parser.Identifier;

public final class UnresolvedExpression
extends TypedExpression {
    private UnresolvedMetadataObjectReference m_ObjectReference = null;
    private ExpParser m_ExpParser = null;

    public UnresolvedExpression(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        this.m_ExpParser = expParser;
        this.m_ObjectReference = unresolvedMetadataObjectReference;
        this.setDataType(DataType.NULL_TYPE);
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_ObjectReference.toSyntax(syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(this.m_ObjectReference.getIdentifier()), this.m_ObjectReference.getIDResolver(), 3, 3, MdmQueryColumn.class);
        BaseMetadataObjectReference baseMetadataObjectReference = (BaseMetadataObjectReference)validationContext.validate(unresolvedMetadataObjectReference);
        ColumnExpression columnExpression = new ColumnExpression(this.m_ExpParser, baseMetadataObjectReference);
        return validationContext.validate(columnExpression);
    }

    public ColumnExpression resolveToColumnExpression(ValidationContext validationContext) {
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(this.m_ObjectReference.getIdentifier()), this.m_ObjectReference.getIDResolver(), 3, 3, MdmQueryColumn.class);
        if (!unresolvedMetadataObjectReference.isValidReference()) {
            return null;
        }
        return new ColumnExpression(this.m_ExpParser, unresolvedMetadataObjectReference);
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    DimensionArgument resolveToDimension(ValidationContext validationContext, int n) {
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(this.m_ObjectReference.getIdentifier()), this.m_ObjectReference.getIDResolver(), FunctionDescriptorDimensionArgument.getMinExpectedNumComponents(n), FunctionDescriptorDimensionArgument.getMaxExpectedNumComponents(n), this.m_ObjectReference.getObjectType());
        if (unresolvedMetadataObjectReference.getMinNumComps() != unresolvedMetadataObjectReference.getMaxNumComps()) {
            unresolvedMetadataObjectReference.setObjectType(MdmDimension.class);
        } else if ((n & 2) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmPrimaryDimension.class);
        } else if ((n & 4) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmHierarchyLevel.class);
        } else if ((n & 8) > 0 && (n & 0x10) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmHierarchy.class);
        } else if ((n & 8) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmLevelHierarchy.class);
        } else if ((n & 0x10) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmValueHierarchy.class);
        } else if ((n & 1) > 0) {
            unresolvedMetadataObjectReference.setObjectType(MdmDimensionLevel.class);
        }
        if (!unresolvedMetadataObjectReference.isValidReference()) {
            return null;
        }
        return new DimensionArgument(this.m_ExpParser, unresolvedMetadataObjectReference);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedExpression(this, object);
    }
}

