/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.CaseExpression;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SearchedCase;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class SearchedCaseExpression
extends CaseExpression {
    private SearchedCase[] m_Cases = null;

    private SearchedCase[] getCasesInternal() {
        return this.m_Cases;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("CASE ");
        for (int i = 0; i < this.getCasesInternal().length; ++i) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCasesInternal()[i]);
        }
        syntaxPrintingContext.newLineAndIndent();
        if (null != this.getElseExpression()) {
            syntaxPrintingContext.append("ELSE ");
            syntaxPrintingContext.print(this.getElseExpression());
            syntaxPrintingContext.newLineAndIndent();
        }
        syntaxPrintingContext.append("END ");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getCasesInternal());
        this.setDataType(DataType.NULL_TYPE);
        int n = -1;
        for (int i = 0; i < this.getCasesInternal().length; ++i) {
            n = this.validateExpression(this.getCasesInternal()[i].getThenExpression(), n);
        }
        this.validateExpression(this.getElseExpression(), n);
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return super.checkIfDefinitionIsComplete() && this.areComponentsComplete(this.getCasesInternal());
    }

    public SearchedCaseExpression(SearchedCase[] searchedCaseArray, TypedExpression typedExpression) {
        super(typedExpression);
        SearchedCaseExpression.validateValues(searchedCaseArray, 1);
        this.m_Cases = (SearchedCase[])searchedCaseArray.clone();
        this.initialize();
    }

    public SearchedCaseExpression(List<SearchedCase> list, TypedExpression typedExpression) {
        super(typedExpression);
        SearchedCaseExpression.validateValues(list, 1);
        this.m_Cases = new SearchedCase[list.size()];
        list.toArray(this.m_Cases);
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSearchedCaseExpression(this, object);
    }

    public SearchedCase[] getCases() {
        return (SearchedCase[])this.getCasesInternal().clone();
    }
}

