/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class OrderByElement
extends DataObject {
    private TypedExpression m_Expression = null;
    private boolean m_Ascending = false;
    private boolean m_NullsFirst = false;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getExpression());
        if (this.isAscending()) {
            syntaxPrintingContext.append(" ASC");
        } else {
            syntaxPrintingContext.append(" DESC");
        }
        if (this.isNullsFirst()) {
            syntaxPrintingContext.append(" NULLS FIRST");
        } else {
            syntaxPrintingContext.append(" NULLS LAST");
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_Expression = validationContext.validateExp(this.m_Expression);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getExpression().isDefinitionComplete();
    }

    public OrderByElement(TypedExpression typedExpression, boolean bl, boolean bl2) {
        OrderByElement.validateValue(typedExpression);
        this.m_Expression = typedExpression;
        this.m_Ascending = bl;
        this.m_NullsFirst = bl2;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOrderByElement(this, object);
    }

    public TypedExpression getExpression() {
        return this.m_Expression;
    }

    public boolean isAscending() {
        return this.m_Ascending;
    }

    public boolean isDescending() {
        return !this.isAscending();
    }

    public boolean isNullsFirst() {
        return this.m_NullsFirst;
    }

    public boolean isNullsLast() {
        return !this.isNullsFirst();
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

