/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedMetadataObjectReference;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class ModelCommand
extends SimpleCommand
implements ConsistentSolveCommand {
    public static final String DEFAULT_OPTION = "";
    public static final String SERIAL_OPTION = "SERIAL";
    public static final String PARALLEL_OPTION = "PARALLEL";
    static final String[] ALL_MODEL_OPTIONS = new String[]{"", "PARALLEL", "SERIAL"};
    private String m_Option = null;
    private BaseMetadataObjectReference m_Model = null;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Model.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("MODEL ");
        this.m_Model.toSyntax(syntaxPrintingContext);
        if (DEFAULT_OPTION != this.getOption() && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.3")) {
            syntaxPrintingContext.append(" ");
            syntaxPrintingContext.append(this.getOption());
        }
    }

    public ModelCommand(MdmDimensionCalculationModel mdmDimensionCalculationModel, String string) {
        ModelCommand.validateValue(mdmDimensionCalculationModel);
        this.m_Option = ModelCommand.validateEnum(string, ALL_MODEL_OPTIONS);
        this.m_Model = new MetadataObjectReference(mdmDimensionCalculationModel, MdmDimensionCalculationModel.class);
        this.initialize();
    }

    public ModelCommand(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this(mdmDimensionCalculationModel, DEFAULT_OPTION);
    }

    public ModelCommand(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference, String string) {
        ModelCommand.validateValue(unresolvedMetadataObjectReference);
        this.m_Option = ModelCommand.validateEnum(string, ALL_MODEL_OPTIONS);
        this.m_Model = unresolvedMetadataObjectReference;
        this.initialize();
    }

    public MdmDimensionCalculationModel getModel() {
        return (MdmDimensionCalculationModel)this.m_Model.getBaseMetadataObject();
    }

    public String getModelID() {
        return this.m_Model.getIdentifier().toString();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitModelCommand(this, object);
    }

    public String getOption() {
        return this.m_Option;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_Model = (BaseMetadataObjectReference)validationContext.validate(this.m_Model);
        return this;
    }
}

