/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.olapi.metadata.mdm.Mdm9iNamingConvention;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmBaseObjectVisitor;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.syntax.parser.Identifier;

public final class MdmAWXMLNamingConvention
extends MdmBaseObjectVisitor {
    private String m_OwnerName;
    private MdmMetadataProvider m_MetadataProvider;
    public static final String MEASURE_FOLDER_SUFFIX = "MEASUREFOLDER";
    public static final String DIMENSION_SUFFIX = "DIMENSION";
    public static final String HIERARCHY_SUFFIX = "HIERARCHY";
    public static final String LEVEL_SUFFIX = "LEVEL";
    public static final String ATTRIBUTE_SUFFIX = "ATTRIBUTE";
    public static final String CUBE_SUFFIX = "CUBE";
    public static final String MEASURE_SUFFIX = "MEASURE";

    public MdmAWXMLNamingConvention(String string, MdmMetadataProvider mdmMetadataProvider) {
        this.m_OwnerName = string;
        this.m_MetadataProvider = mdmMetadataProvider;
    }

    public String getOwnerName() {
        return this.m_OwnerName;
    }

    void setOwnerName(String string) {
        this.m_OwnerName = string;
    }

    public String generateSchemaID(String string) {
        return this.generateSchemaID(string, true);
    }

    private String generateSchemaID(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        this.appendSuffix(stringBuffer, MEASURE_FOLDER_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generatePrimaryDimensionID(String string) {
        return this.generatePrimaryDimensionID(string, true);
    }

    private String generatePrimaryDimensionID(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        this.appendSuffix(stringBuffer, DIMENSION_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generateHierarchyID(String string, String string2) {
        String string3 = this.generatePrimaryDimensionID(string, false);
        return this.generateHierarchyID(string3, string2, true);
    }

    private String generateHierarchyID(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        this.appendSuffix(stringBuffer, HIERARCHY_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generateLevelID(String string, String string2) {
        String string3 = this.generatePrimaryDimensionID(string, false);
        return this.generateLevelID(string3, string2, true);
    }

    private String generateLevelID(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        this.appendSuffix(stringBuffer, LEVEL_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generateAttributeID(String string, String string2) {
        String string3 = this.generatePrimaryDimensionID(string, false);
        return this.generateAttributeID(string3, string2, true);
    }

    private String generateAttributeID(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        this.appendSuffix(stringBuffer, ATTRIBUTE_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generateMeasureID(String string, String string2) {
        String string3 = this.generateCubeID(string, false);
        return this.generateMeasureID(string3, string2, true);
    }

    private String generateMeasureID(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        this.appendSuffix(stringBuffer, MEASURE_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public String generateCubeID(String string) {
        return this.generateCubeID(string, true);
    }

    private String generateCubeID(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        this.appendSuffix(stringBuffer, CUBE_SUFFIX, bl);
        return stringBuffer.toString();
    }

    public final String generateID(MdmObject mdmObject) {
        String string = Mdm9iNamingConvention.getOwnerName(this.getMdmMetadataProvider(), mdmObject);
        String string2 = this.getOwnerName();
        this.setOwnerName(string);
        String string3 = this.generateID(mdmObject, null);
        this.setOwnerName(string2);
        return string3;
    }

    private String generateID(MdmObject mdmObject, Object object) {
        return (String)mdmObject.acceptVisitor(this, object);
    }

    private void appendSuffix(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl) {
            stringBuffer.append(".");
            stringBuffer.append(string);
        }
    }

    @Override
    public Object visitMdmObject(MdmObject mdmObject, Object object) {
        return null;
    }

    @Override
    public Object visitMdmOrganizationalSchema(MdmOrganizationalSchema mdmOrganizationalSchema, Object object) {
        return this.generateSchemaID(mdmOrganizationalSchema.getName(), true);
    }

    @Override
    public Object visitMdmSchema(MdmSchema mdmSchema, Object object) {
        if (mdmSchema.getName().equals("RootSchema")) {
            return super.visitMdmSchema(mdmSchema, object);
        }
        return this.generateSchemaID(mdmSchema.getName(), true);
    }

    @Override
    public Object visitMdmPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension, Object object) {
        boolean bl = null == object;
        return this.generatePrimaryDimensionID(mdmPrimaryDimension.getName(), bl);
    }

    @Override
    public Object visitMdmMeasureDimension(MdmMeasureDimension mdmMeasureDimension, Object object) {
        return null;
    }

    @Override
    public Object visitMdmHierarchy(MdmHierarchy mdmHierarchy, Object object) {
        String string = this.generateID(mdmHierarchy.getPrimaryDimension(), mdmHierarchy);
        return this.generateHierarchyID(string, mdmHierarchy.getName(), true);
    }

    @Override
    public Object visitMdmHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel, Object object) {
        String string = this.generateID(mdmHierarchyLevel.getPrimaryDimension(), mdmHierarchyLevel);
        return this.generateLevelID(string, mdmHierarchyLevel.getName(), true);
    }

    @Override
    public Object visitMdmAttribute(MdmAttribute mdmAttribute, Object object) {
        String string = this.generateID(mdmAttribute.getPrimaryDimension(), mdmAttribute);
        return this.generateAttributeID(string, mdmAttribute.getName(), true);
    }

    @Override
    public Object visitMdmDerivedAttribute(MdmDerivedAttribute mdmDerivedAttribute, Object object) {
        return null;
    }

    @Override
    public Object visitMdmMeasure(MdmMeasure mdmMeasure, Object object) {
        MdmCube mdmCube = mdmMeasure.getCube();
        String string = null;
        string = null == mdmCube ? this.getIDComponent(mdmMeasure.getID(), 1) : mdmCube.getName();
        return this.generateMeasureID(string, mdmMeasure.getName());
    }

    @Override
    public Object visitMdmCube(MdmCube mdmCube, Object object) {
        return this.generateCubeID(mdmCube.getName());
    }

    public MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MetadataProvider;
    }

    public String getParentIDType(String string) {
        if (string.equals(HIERARCHY_SUFFIX) || string.equals(LEVEL_SUFFIX) || string.equals(ATTRIBUTE_SUFFIX)) {
            return DIMENSION_SUFFIX;
        }
        if (string.equals(MEASURE_SUFFIX)) {
            return CUBE_SUFFIX;
        }
        return null;
    }

    private String getIDComponent(String string, int n) {
        Identifier identifier = Identifier.parseID(string);
        if (identifier.hasNamespace()) {
            ++n;
        }
        return identifier.getComponent(n);
    }
}

