/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.XMLTag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XMLReaderPropertyAction {
    private static String[] VALID_ACTIONS = BaseMetadataXMLTags.ACTION.getAcceptableValues();
    private int m_Action = -1;
    private int m_ListPosition = -1;
    private short m_PersistenceType = (short)-1;
    private boolean m_IgnoreFixedStatus = false;

    XMLReaderPropertyAction() {
    }

    XMLReaderPropertyAction(short s) {
        this.setToDefault();
        this.setPersistenceType(s);
    }

    public XMLReaderPropertyAction(short s, boolean bl) {
        this.setToDefault();
        this.setPersistenceType(s);
        this.setIgnoreFixedStatus(bl);
    }

    boolean populate(XMLTag xMLTag, Attributes attributes, BaseMetadataXMLReader baseMetadataXMLReader) throws SAXException {
        String string;
        this.m_Action = -1;
        this.m_ListPosition = -1;
        XMLTag xMLTag2 = BaseMetadataXMLTags.ACTION;
        String string2 = baseMetadataXMLReader.getAttributeValue(attributes, xMLTag2, false);
        if (null == string2) {
            return false;
        }
        this.m_Action = xMLTag2.validateStringValueByIndex(string2);
        if (1 == xMLTag.getDataStructureType() && null != (string = baseMetadataXMLReader.getAttributeValue(attributes, BaseMetadataXMLTags.LIST_POSITION, false))) {
            try {
                this.m_ListPosition = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.m_ListPosition = -1;
            }
        }
        return true;
    }

    void setToDefault() {
        this.m_Action = 0;
        this.m_ListPosition = -1;
    }

    boolean hasPropertyXMLTag(String string, String string2) {
        if (BaseMetadataXMLTags.ACTION.matches(string, string2)) {
            return true;
        }
        return -1 != this.getListPosition() && BaseMetadataXMLTags.LIST_POSITION.matches(string, string2);
    }

    int getListPosition() {
        return this.m_ListPosition;
    }

    boolean isAdd() {
        return "ADD" == VALID_ACTIONS[this.m_Action];
    }

    boolean isRemove() {
        return "REMOVE" == VALID_ACTIONS[this.m_Action];
    }

    boolean isClear() {
        return "CLEAR" == VALID_ACTIONS[this.m_Action];
    }

    int getAction() {
        return this.m_Action;
    }

    void setPersistenceType(short s) {
        this.m_PersistenceType = s;
    }

    short getPersistenceType() {
        return this.m_PersistenceType;
    }

    void setIgnoreFixedStatus(boolean bl) {
        this.m_IgnoreFixedStatus = bl;
    }

    boolean getIgnoreFixedStatus() {
        return this.m_IgnoreFixedStatus;
    }
}

