/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.io.IOException;
import oracle.express.ObjectClosedException;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterface;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLFetcher;
import oracle.olapi.metadata.XMLFetcher11g;
import oracle.olapi.metadata.XMLFetcher9203;
import oracle.olapi.session.UserSession;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MetadataFetcher {
    private BaseMetadataProvider m_BaseMetadataProvider = null;
    private XMLFetcher m_XMLFetcher = null;
    private boolean m_SupportsMetadataUpdate = false;
    private int m_maxFetchSize = 10;
    public static final short PERSISTENCE_TYPE_NONE = -1;
    public static final short TRANSIENT_METADATA = 0;
    public static final short SERVER_PERSISTENT_METADATA = 1;
    public static final short CLIENT_PERSISTENT_METADATA = 2;
    public static final short SERVER_PERSISTENT_INCREMENTAL_METADATA = 3;

    MetadataFetcher(BaseMetadataProvider baseMetadataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) {
        this.setBaseMetadataProvider(baseMetadataProvider);
        this.initialize(clientXMLMetadataFetcher);
    }

    private void initialize(ClientXMLMetadataFetcher clientXMLMetadataFetcher) {
        String string = this.getBaseMetadataProvider().getDataProvider().getProperty("XMLFetchSize");
        if (null != string) {
            try {
                this.m_maxFetchSize = Integer.valueOf(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataProvider dataProvider = this.getBaseMetadataProvider().getDataProvider();
        MetadataProviderInterface metadataProviderInterface = dataProvider.getMetadataProviderInterface();
        XMLFetcher xMLFetcher = null;
        if (null != clientXMLMetadataFetcher) {
            xMLFetcher = clientXMLMetadataFetcher;
        } else if (dataProvider.read11gMetadata()) {
            xMLFetcher = new XMLFetcher11g(metadataProviderInterface, dataProvider);
        } else if (dataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            xMLFetcher = new XMLFetcher9203(metadataProviderInterface);
        }
        this.setXMLFetcher(xMLFetcher);
        this.setSupportsMetadataUpdate(true);
    }

    private MetadataXMLReader createXMLReader() {
        MetadataXMLReader metadataXMLReader = new MetadataXMLReader(this.getXMLFetcher().getPersistenceType(), this.getBaseMetadataProvider());
        return metadataXMLReader;
    }

    void fetchBaseMetadataObjects(String[] stringArray) throws ObjectClosedException {
        MetadataXMLReader metadataXMLReader = this.createXMLReader();
        InputSource inputSource = this.getXMLFetcher().fetchXML(stringArray);
        this.processXML(inputSource, metadataXMLReader);
    }

    public BaseMetadataProvider getBaseMetadataProvider() {
        return this.m_BaseMetadataProvider;
    }

    String getID() {
        return this.getXMLFetcher().getID();
    }

    private XMLFetcher getXMLFetcher() {
        return this.m_XMLFetcher;
    }

    private void processXML(InputSource inputSource, MetadataXMLReader metadataXMLReader) {
        if (null == inputSource) {
            return;
        }
        try {
            DataProvider dataProvider = this.getBaseMetadataProvider().getDataProvider();
            UserSession userSession = dataProvider.getCurrentSession();
            metadataXMLReader.setUserCallback(userSession.getServerXMLParserCallback());
            metadataXMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    void processXML(InputSource inputSource) {
        MetadataXMLReader metadataXMLReader = this.createXMLReader();
        this.processXML(inputSource, metadataXMLReader);
    }

    private void setBaseMetadataProvider(BaseMetadataProvider baseMetadataProvider) {
        this.m_BaseMetadataProvider = baseMetadataProvider;
    }

    private void setSupportsMetadataUpdate(boolean bl) {
        this.m_SupportsMetadataUpdate = bl;
    }

    private void setXMLFetcher(XMLFetcher xMLFetcher) {
        this.m_XMLFetcher = xMLFetcher;
    }

    private boolean supportsMetadataUpdate() {
        return this.m_SupportsMetadataUpdate;
    }
}

