/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import oracle.express.olapi.replay.DefinitionWriterParameters;
import oracle.express.olapi.replay.VisitedNameSource;
import oracle.express.olapi.replay.XMLFactory;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import org.w3c.dom.Element;

class WriterContext {
    private VisitedNameSource _visited = new VisitedNameSource();
    private DefinitionWriterParameters _parameters = null;
    private XMLFactory _factory = null;
    private FundamentalMetadataProvider fmdp = null;
    private Source _emptySource = null;
    private Source _voidSource = null;

    WriterContext(XMLFactory xMLFactory, DefinitionWriterParameters definitionWriterParameters) {
        this._factory = xMLFactory;
        this._parameters = definitionWriterParameters;
    }

    DefinitionWriterParameters getParameters() {
        return this._parameters;
    }

    XMLFactory getFactory() {
        return this._factory;
    }

    final boolean isVisited(SourceDefinition sourceDefinition) {
        return this._visited.hasElement(sourceDefinition);
    }

    Element getVisitedElement(SourceDefinition sourceDefinition) {
        Element element = this.getFactory().createElement("Ref");
        element.setAttributeNode(this.getFactory().createAttribute("id", this.makeName(sourceDefinition)));
        return element;
    }

    final String makeName(SourceDefinition sourceDefinition) {
        return this._visited.makeName(sourceDefinition);
    }

    FundamentalMetadataProvider getFundamentalMetadataProvider(SourceDefinition sourceDefinition) {
        if (this.fmdp == null) {
            Source source = sourceDefinition.getSource();
            DataProvider dataProvider = source.getDataProvider();
            this.fmdp = dataProvider.getFundamentalMetadataProvider();
        }
        return this.fmdp;
    }

    boolean isFundamental(SourceDefinition sourceDefinition) {
        try {
            return sourceDefinition.getSource().getMetadataProvider() == this.getFundamentalMetadataProvider(sourceDefinition);
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isEmptySource(SourceDefinition sourceDefinition) {
        try {
            if (this._emptySource == null) {
                this._emptySource = this.getFundamentalMetadataProvider(sourceDefinition).getEmptyDataType().getSource();
            }
            return sourceDefinition.getSource() == this._emptySource;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isVoidSource(SourceDefinition sourceDefinition) {
        try {
            if (this._voidSource == null) {
                this._voidSource = this.getFundamentalMetadataProvider(sourceDefinition).getVoidDataType().getSource();
            }
            return sourceDefinition.getSource() == this._voidSource;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

