/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.lang.reflect.Array;
import java.util.Enumeration;
import oracle.express.olapi.replay.BaseSourceHandler;
import oracle.express.olapi.replay.ElementFactory;
import oracle.express.olapi.replay.InvalidSourceNodeException;
import oracle.express.olapi.replay.JoinHandler;
import oracle.express.olapi.replay.MethodExecutor;
import oracle.express.olapi.replay.NestedException;
import oracle.express.olapi.replay.NestedNodeContextException;
import oracle.express.olapi.replay.NodeContext;
import oracle.express.olapi.replay.Providers;
import oracle.express.olapi.replay.SourceCache;
import oracle.express.olapi.replay.SourceHandler;
import oracle.express.olapi.replay.SourceNodeNotFoundException;
import oracle.express.olapi.replay.XMLNodeHandler;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;

class DefinitionHandler
extends SourceHandler {
    private Providers _providers;
    private SourceCache _cache;
    private ElementFactory handlers;

    public DefinitionHandler(XMLNodeHandler xMLNodeHandler, Providers providers, SourceCache sourceCache) {
        super(xMLNodeHandler);
        this._providers = providers;
        this._cache = sourceCache;
        this.handlers = new DefinitionFactory(this._providers);
    }

    @Override
    protected String getType() {
        return "Definition";
    }

    @Override
    protected Object doHandle(NodeContext nodeContext) throws SourceNodeNotFoundException, InvalidSourceNodeException {
        String string = nodeContext.getID();
        nodeContext = nodeContext.getFirstChild();
        Object object = this.handlers.create(nodeContext);
        this._cache.put(string, object);
        return object;
    }

    class SourceTypeDataProvider {
        private DataProvider dp = null;

        public SourceTypeDataProvider(DataProvider dataProvider) {
            this.dp = dataProvider;
        }

        public Source create(Boolean[] booleanArray) {
            boolean[] blArray = new boolean[booleanArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = booleanArray[i];
            }
            return this.dp.createListSource(blArray);
        }

        public Source create(Double[] doubleArray) {
            double[] dArray = new double[doubleArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = doubleArray[i];
            }
            return this.dp.createListSource(dArray);
        }

        public Source create(Float[] floatArray) {
            float[] fArray = new float[floatArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = floatArray[i].floatValue();
            }
            return this.dp.createListSource(fArray);
        }

        public Source create(Integer[] integerArray) {
            int[] nArray = new int[integerArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = integerArray[i];
            }
            return this.dp.createListSource(nArray);
        }

        public Source create(Short[] shortArray) {
            short[] sArray = new short[shortArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = shortArray[i];
            }
            return this.dp.createListSource(sArray);
        }

        public Source create(String[] stringArray) {
            return this.dp.createListSource(stringArray);
        }

        public Source create(Source[] sourceArray) {
            return this.dp.createListSource(sourceArray);
        }
    }

    class DynamicHandler
    extends SourceHandler {
        public DynamicHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Dynamic";
        }

        @Override
        protected Object doHandle(NodeContext nodeContext) throws NestedException {
            Object object = nodeContext.find("Current").getFirstChild().create();
            return object;
        }
    }

    class ValueHandler
    extends SourceHandler {
        public ValueHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Value";
        }

        @Override
        public Object doHandle(NodeContext nodeContext) throws NestedNodeContextException {
            try {
                Source source = (Source)nodeContext.find("Base/*[1]").create();
                Source source2 = (Source)nodeContext.find("Input/*[1]").create();
                return source.value(source2);
            }
            catch (SourceNodeNotFoundException sourceNodeNotFoundException) {
                throw new InvalidSourceNodeException(this.getClass(), nodeContext, sourceNodeNotFoundException);
            }
        }
    }

    class PositionHandler
    extends BaseSourceHandler {
        public PositionHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Position";
        }

        @Override
        protected Source doMakeFromBase(Source source) {
            return source.position();
        }
    }

    class ExtractHandler
    extends BaseSourceHandler {
        public ExtractHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Extract";
        }

        @Override
        protected Source doMakeFromBase(Source source) {
            return source.extract();
        }
    }

    class DistinctHandler
    extends BaseSourceHandler {
        public DistinctHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Distinct";
        }

        @Override
        protected Source doMakeFromBase(Source source) {
            return source.distinct();
        }
    }

    class AliasHandler
    extends BaseSourceHandler {
        public AliasHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Alias";
        }

        @Override
        protected Source doMakeFromBase(Source source) {
            return source.alias();
        }
    }

    private class DefinitionFactory
    extends ElementFactory {
        public DefinitionFactory(Providers providers) {
            super(providers);
        }

        @Override
        protected XMLNodeHandler initHandlers() {
            SourceHandler sourceHandler = null;
            sourceHandler = new SourceDefinitionHandler(sourceHandler);
            sourceHandler = new DynamicHandler(sourceHandler);
            sourceHandler = new JoinHandler(sourceHandler);
            sourceHandler = new RangeHandler(sourceHandler);
            sourceHandler = new ConstantListHandler(sourceHandler);
            sourceHandler = new AliasHandler(sourceHandler);
            sourceHandler = new DistinctHandler(sourceHandler);
            sourceHandler = new ExtractHandler(sourceHandler);
            sourceHandler = new PositionHandler(sourceHandler);
            sourceHandler = new ValueHandler(sourceHandler);
            return sourceHandler;
        }

        private class RangeHandler
        extends SourceHandler {
            public RangeHandler(XMLNodeHandler xMLNodeHandler) {
                super(xMLNodeHandler);
            }

            @Override
            protected String getType() {
                return "Range";
            }

            @Override
            protected Object doHandle(NodeContext nodeContext) throws NestedException {
                Object object = nodeContext.find("Bottom").getFirstChild().create();
                Object object2 = nodeContext.find("Top").getFirstChild().create();
                return DefinitionFactory.this.getProviders().create("createRangeSource", object, object2);
            }
        }

        private class ConstantListHandler
        extends SourceHandler {
            private SourceTypeDataProvider sourceProvider;

            public ConstantListHandler(XMLNodeHandler xMLNodeHandler) {
                super(xMLNodeHandler);
                this.sourceProvider = new SourceTypeDataProvider(DefinitionFactory.this.getProviders().getDataProvider());
            }

            @Override
            protected String getType() {
                return "ConstantList";
            }

            @Override
            protected Object doHandle(NodeContext nodeContext) throws InvalidSourceNodeException {
                try {
                    Object object;
                    NodeContext nodeContext2 = nodeContext.find("Elements/List");
                    Enumeration enumeration = nodeContext2.getChildEnumeration();
                    Object object2 = null;
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        object = (NodeContext)enumeration.nextElement();
                        Object object3 = ((NodeContext)object).create();
                        if (object2 == null) {
                            int n2 = nodeContext2.getChildrenCount();
                            object2 = Array.newInstance(object3.getClass(), n2);
                        }
                        Array.set(object2, n++, object3);
                    }
                    object = (Source)MethodExecutor.invoke(this.sourceProvider, "create", new Object[]{object2});
                    return object;
                }
                catch (SourceNodeNotFoundException sourceNodeNotFoundException) {
                    throw new InvalidSourceNodeException(this.getClass(), nodeContext, sourceNodeNotFoundException);
                }
                catch (Exception exception) {
                    throw new InvalidSourceNodeException(this.getClass(), nodeContext, exception);
                }
            }
        }

        private class SourceDefinitionHandler
        extends SourceHandler {
            public SourceDefinitionHandler(XMLNodeHandler xMLNodeHandler) {
                super(xMLNodeHandler);
            }

            @Override
            protected String getType() {
                return "Source";
            }

            @Override
            protected boolean canHandle(NodeContext nodeContext) {
                try {
                    if (!super.canHandle(nodeContext)) {
                        return false;
                    }
                    String string = this.getProviderID(nodeContext);
                    return DefinitionFactory.this.getProviders().getMetadataProvider(string) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            protected Object doHandle(NodeContext nodeContext) throws SourceNodeNotFoundException {
                Source source = DefinitionFactory.this.getProviders().getSourceByName(this.getProviderID(nodeContext), this.getPersistentID(nodeContext));
                return source;
            }

            protected String getProviderID(NodeContext nodeContext) throws SourceNodeNotFoundException {
                return nodeContext.find("MetadataProvider").getText();
            }

            protected String getPersistentID(NodeContext nodeContext) throws SourceNodeNotFoundException {
                return nodeContext.find("PersistentID").getText();
            }
        }
    }
}

