/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class HEXEncoding
extends Encoding
implements Decoder,
Encoder {
    private static final char[] map0;
    private static final char[] map1;
    private static byte[] map2;

    public HEXEncoding(MimeType mimeType) {
        super(EncodingType.ENCODING_HEX, mimeType);
    }

    public char[] encodeToCharArray(byte[] in) throws EncodingException, IOException {
        return this.encodeToCharArray(in, -1, null);
    }

    public char[] encodeToCharArray(byte[] in, int breakAt, String breakChars) throws EncodingException, IOException {
        return this.encodeToString(in, breakAt, breakChars).toCharArray();
    }

    public String encodeToString(byte[] in) throws EncodingException, IOException {
        return this.encodeToString(in, -1, null);
    }

    public String encodeToString(byte[] in, int breakAt, String breakChars) throws EncodingException, IOException {
        StringWriter os = new StringWriter();
        this.encode(new ByteArrayInputStream(in), os, breakAt, breakChars);
        return os.toString();
    }

    @Override
    public long getEncodeLength(long inLen) {
        return this.getEncodeLength(inLen, -1, null);
    }

    public long getEncodeLength(byte[] in, int breakAt, String breakChars) {
        return this.getEncodeLength(in.length, breakAt, breakChars);
    }

    public long getEncodeLength(long inLen, int breakAt, String breakChars) {
        long iLen = inLen;
        long oLen = iLen * 2L;
        long breakLen = 0L;
        if (breakAt > 0 && breakChars != null) {
            int breakSeg = breakChars.length();
            breakLen = oLen / (long)breakAt * (long)breakSeg;
            if (oLen % (long)breakAt == 0L) {
                breakLen -= (long)breakSeg;
            }
        }
        return oLen + breakLen;
    }

    public void encode(InputStream in, Writer out) throws EncodingException, IOException {
        this.encode(in, out, -1, null);
    }

    public void encode(InputStream in, Writer out, int breakAt, String breakChars) throws EncodingException, IOException {
        long ip = 0L;
        long op = 0L;
        int i0 = in.read();
        while (i0 != -1) {
            ++ip;
            int v = i0 & 0xFF;
            int o0 = v >> 4;
            int o1 = v & 0xF;
            HEXEncoding.writeChar(out, map0[o0], op++, breakAt, breakChars);
            HEXEncoding.writeChar(out, map0[o1], op++, breakAt, breakChars);
            i0 = in.read();
        }
        out.flush();
    }

    private static void writeChar(Writer out, int c, long count, int breakAt, String breakChars) throws IOException {
        if (breakAt > 0 && count > 0L && breakChars != null && count % (long)breakAt == 0L) {
            out.write(breakChars);
        }
        out.write(c);
    }

    public byte[] decodeToByteArray(char[] in) throws EncodingException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.decode(new CharArrayReader(in), os);
        return os.toByteArray();
    }

    public byte[] decodeToByteArray(String in) throws EncodingException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.decode(new StringReader(in), os);
        return os.toByteArray();
    }

    public long getDecodeLength(String in) throws EncodingException {
        long iLen = 0L;
        for (int i = 0; i < in.length(); ++i) {
            if (Character.isWhitespace(in.charAt(i))) continue;
            ++iLen;
        }
        return this.getDecodeLength(iLen);
    }

    public long getDecodeLength(char[] in) throws EncodingException {
        long iLen = 0L;
        for (int i = 0; i < in.length; ++i) {
            if (Character.isWhitespace(in[i])) continue;
            ++iLen;
        }
        return this.getDecodeLength(iLen);
    }

    @Override
    public long getDecodeLength(long inLen) throws EncodingException {
        if (inLen % 2L != 0L) {
            throw new EncodingException("Length of Hex encoded input string is not a multiple of 2.");
        }
        return inLen / 2L;
    }

    @Override
    public int getDecodeBlocksize() {
        return 2;
    }

    @Override
    public int getEncodeBlocksize() {
        return 1;
    }

    public void decode(Reader in, OutputStream out) throws EncodingException, IOException {
        int i0 = HEXEncoding.readChar(in);
        while (i0 != -1) {
            int i1 = HEXEncoding.readChar(in);
            if (i1 == -1) {
                throw new EncodingException("Length of Hex encoded input is not a multiple of 2.");
            }
            if (i0 > 127 || i1 > 127) {
                throw new EncodingException("Illegal character in Hex encoded input.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            if (b0 < 0 || b1 < 0) {
                throw new EncodingException("Illegal character in Hex encoded input.");
            }
            int o0 = b0 << 4 | b1 & 0xF;
            out.write(o0);
            i0 = HEXEncoding.readChar(in);
        }
        out.flush();
    }

    private static int readChar(Reader in) throws IOException {
        int i = in.read();
        while (i != -1 && Character.isWhitespace((char)i)) {
            i = in.read();
        }
        return i;
    }

    public Object decodeBuffer(Object in) throws EncodingException, IOException {
        if (in == null) {
            return null;
        }
        return this.decodeToByteArray((String)in);
    }

    @Override
    public void decodeStream(Object in, Object out) throws EncodingException, IOException {
        this.decode((Reader)in, (OutputStream)out);
    }

    public Object encodeBuffer(Object in) throws EncodingException, IOException {
        if (in == null) {
            return null;
        }
        return this.encodeToString((byte[])in);
    }

    @Override
    public void encodeStream(Object in, Object out) throws EncodingException, IOException {
        this.encode((InputStream)in, (Writer)out);
    }

    static {
        int i;
        map0 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        map1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            HEXEncoding.map2[i] = -1;
        }
        for (i = 0; i < map0.length; ++i) {
            HEXEncoding.map2[HEXEncoding.map0[i]] = (byte)i;
        }
        for (i = 0; i < map1.length; ++i) {
            HEXEncoding.map2[HEXEncoding.map1[i]] = (byte)i;
        }
    }
}

