/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ucp;

import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.DataSourceBuilderBase;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;

public class PoolDataSources {
    private static final PoolDataSources INSTANCE = new PoolDataSources();

    public static PoolDataSources instance() {
        return INSTANCE;
    }

    private PoolDataSources() {
    }

    public Builder builder() throws SQLException {
        return new Builder();
    }

    public static class Builder
    extends DataSourceBuilderBase<PoolDataSource> {
        protected Builder() {
        }

        @Override
        protected void configure(PoolDataSource ds, String url, String user, String password, Properties connectionProperties, SSLContext sslContext, Boolean fastConnectionFailover, String onsConfiguration) throws SQLException {
            if (url != null) {
                ds.setURL(url);
            }
            if (user != null) {
                ds.setUser(user);
            }
            if (password != null) {
                ds.setPassword(password);
            }
            if (sslContext != null) {
                ds.setSSLContext(sslContext);
            }
            if (fastConnectionFailover != null) {
                ds.setFastConnectionFailoverEnabled(fastConnectionFailover.booleanValue());
            }
            if (onsConfiguration != null) {
                ds.setONSConfiguration(onsConfiguration);
            }
            if (connectionProperties != null) {
                ds.setConnectionProperties(connectionProperties);
            }
        }

        @Override
        protected void configureHostNameResolver(PoolDataSource ds, DataSourceBuilder.HostnameResolver hostnameResolver) {
            if (hostnameResolver != null) {
                ds.setHostnameResolver(hostnameResolver::getAllByName);
            }
        }

        @Override
        public Builder connectionProperties(Properties connectionProperties) {
            super.connectionProperties(connectionProperties);
            return this;
        }

        @Override
        protected PoolDataSource createDataSource() {
            return new PoolDataSourceImpl();
        }

        @Override
        public Builder fastConnectionFailover(Boolean enabled) {
            super.fastConnectionFailover(enabled);
            return this;
        }

        @Override
        public Builder hostnameResolver(DataSourceBuilder.HostnameResolver hostnameResolver) {
            super.hostnameResolver(hostnameResolver);
            return this;
        }

        @Override
        public Builder onsConfiguration(String onsConfig) {
            super.onsConfiguration(onsConfig);
            return this;
        }

        @Override
        public Builder password(String password) {
            super.password(password);
            return this;
        }

        @Override
        public Builder serviceAlias(String serviceAlias) {
            super.serviceAlias(serviceAlias);
            return this;
        }

        @Override
        public Builder sslContext(SSLContext sslContext) {
            super.sslContext(sslContext);
            return this;
        }

        @Override
        public Builder url(String url) {
            super.url(url);
            return this;
        }

        @Override
        public Builder user(String user) {
            super.user(user);
            return this;
        }
    }
}

