/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class ToolLogger {
    private File _file;
    private OutputStream _outs;
    private BufferedOutputStream _bouts;
    protected OutputStreamWriter _out;
    private String _encoding = this.getEncoding();
    private String _eol;
    private String _logName;
    private String _toolName = "";
    private String _processName;
    private String _stepName;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    private String _startTime;
    private String _endTime;

    public ToolLogger() {
    }

    public ToolLogger(OutputStreamWriter osWriter) {
        this._startTime = this.getStartTime();
        this._out = osWriter;
        this.setWriter();
    }

    public ToolLogger(OutputStream outputStream) {
        this._startTime = this.getStartTime();
        this._outs = outputStream;
        this.setWriter();
    }

    public ToolLogger(File file) {
        this._startTime = this.getStartTime();
        this._file = file;
        this.setWriter();
    }

    public ToolLogger(File file, String encoding) {
        this._startTime = this.getStartTime();
        this._file = file;
        this._encoding = encoding;
        this.setWriter();
    }

    public ToolLogger(String encoding) {
        this(ToolLoggerResources.getString("TOOL"), encoding);
    }

    public ToolLogger(String importFileName, String encoding) {
        this(importFileName, encoding, null);
    }

    public ToolLogger(String importFileName, String encoding, String extension) {
        this(importFileName, encoding, extension, null);
    }

    public ToolLogger(String importFileName, String encoding, String extension, String genDirPath) {
        Object dir;
        String ext = extension == null ? ".log" : extension;
        this._encoding = encoding;
        this._startTime = this.getStartTime();
        Object object = dir = genDirPath == null || genDirPath.isEmpty() ? this.getUserDirectory() : genDirPath;
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        this._logName = (String)dir + importFileName + "_" + this._startTime + ext;
        this._file = new File(this._logName);
        this.setWriter();
    }

    public String getStartTime() {
        if (this._startTime == null) {
            this._startTime = this._dateFormat.format(new Date());
        }
        return this._startTime;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setWriter() {
        try {
            if (this._out == null) {
                if (this._outs == null) {
                    this._outs = new FileOutputStream(this._file.getPath());
                }
                this._bouts = new BufferedOutputStream(this._outs);
                this._out = new OutputStreamWriter((OutputStream)this._bouts, this._encoding);
            }
            this.setTerm();
        }
        catch (IOException io) {
            if (this._file != null) {
                String msg1 = ToolLoggerResources.getString("LOG_FILE_CREATION_ERROR");
                String msg2 = this._file.getPath() + this._file.getName();
                this.error(io, msg1, msg2);
            }
            String msg1 = ToolLoggerResources.getString("LOG_FILE_CREATION_ERROR");
            String msg2 = "ExtractLog";
            this.error(io, msg1, msg2);
        }
    }

    public OutputStreamWriter getWriter() {
        return this._out;
    }

    public String getLogName() {
        return this._logName;
    }

    public String getDefaultTerm() {
        return System.getProperty("line.separator");
    }

    public String getEncoding() {
        return System.getProperty("file.encoding");
    }

    public String getUserDirectory() {
        return System.getProperty("user.home");
    }

    public void log(String text) {
        this.log(text, false);
    }

    public void log(String text, boolean forceDisplay) {
        try {
            if (this._out != null) {
                this._out.write(text + (text.endsWith(this.getTerm()) ? "" : this.getTerm()));
            }
        }
        catch (IOException e) {
            Logger.warn(ToolLogger.class, e);
        }
    }

    public void logLabel(String text) {
        this.log(text, false);
    }

    public void logLabel(String text, boolean forceDisplay) {
        try {
            if (this._out != null) {
                this._out.write(text);
            }
        }
        catch (IOException e) {
            Logger.warn(ToolLogger.class, e);
        }
    }

    public void logToolStart(String text) {
        this._toolName = text;
        this.log(this.getTerm());
        this.log(ToolLoggerResources.format("LOG_TOOL_START", text, this._startTime));
    }

    public void logToolEnd() {
        this._endTime = this._dateFormat.format(new Date());
        this.log(ToolLoggerResources.format("LOG_TOOL_END", this._toolName, this._endTime));
    }

    public void logProcessStart(String text) {
        this._processName = text;
        this.log(ToolLoggerResources.getString("LOG_SEPARATOR"));
        this.log(ToolLoggerResources.format("LOG_PROCESS_START", text));
    }

    public void logProcessEnd() {
        this.log(ToolLoggerResources.format("LOG_PROCESS_END", this._processName));
        this.log(ToolLoggerResources.getString("LOG_SEPARATOR"));
    }

    public void logStepStart(String text) {
        this._stepName = text;
        this.log(ToolLoggerResources.getString("LOG_SEPARATOR"));
        this.log(ToolLoggerResources.format("LOG_STEP_START", text));
    }

    public void logStepEnd() {
        this.log(ToolLoggerResources.format("LOG_STEP_END", this._stepName));
        this.log(ToolLoggerResources.getString("LOG_SEPARATOR"));
    }

    public void logElapsedTime(long start) {
        this.log(ToolLoggerResources.format("TIMINGELAPSED", ToolLogger.getElapsedTime(start)));
    }

    public void logElapsedTotalTime(long start) {
        this.log(ToolLoggerResources.format("TIMINGELAPSEDTOTAL", ToolLogger.getElapsedTime(start)));
    }

    public void logWarning(String text) {
        this.log(ToolLoggerResources.format("LOG_WARNING", text), true);
    }

    public void logError(String text) {
        this.log(ToolLoggerResources.format("LOG_ERROR", text), true);
    }

    public void logException(Throwable t) {
        if (t != null) {
            String text = this.getExceptionText(t);
            this.log(ToolLoggerResources.format("EXCEPTION", text));
        }
    }

    protected String getExceptionText(Throwable t) {
        String text = t.getLocalizedMessage();
        if (t.getCause() != null) {
            text = t.getCause().toString();
        }
        if (text == null) {
            text = String.valueOf(t);
        }
        return text;
    }

    public void logHref(URL url) {
        if (this._out != null) {
            this.log(url.toExternalForm());
        }
    }

    public void flushLog() {
        try {
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (IOException e) {
            Logger.warn(ToolLogger.class, e);
        }
    }

    public void finished() {
        this.closeLog();
    }

    public void closeLog() {
        try {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
                this._out = null;
            }
            this._outs = null;
            this._bouts = null;
        }
        catch (IOException e) {
            Logger.warn(ToolLogger.class, e);
        }
    }

    public boolean isFileUsed() {
        return this._file != null & this._file.exists() && this._file.length() > 0L;
    }

    public void deleteEmptyFile() {
        if (this._file != null && this._file.exists() && this._file.length() == 0L) {
            this._file.delete();
        }
    }

    public void setTerm() {
        if (this._eol == null) {
            this._eol = this.getDefaultTerm();
        }
    }

    public String getTerm() {
        return this._eol;
    }

    public void setTerm(String eol) {
        this._eol = eol;
    }

    public URL getURL() {
        try {
            if (this._file != null) {
                return this._file.toURI().toURL();
            }
        }
        catch (Exception e) {
            Logger.warn(ToolLogger.class, e);
        }
        return null;
    }

    public static String getTempDir() throws IOException {
        File tempFile = File.createTempFile("pref", "suf");
        String dirPath = tempFile.getParentFile().getPath();
        tempFile.delete();
        return dirPath;
    }

    public static String getElapsedTime(long start) {
        long stop = System.currentTimeMillis();
        long interval = stop - start;
        long totalMilliseconds = stop - start;
        long remainderMilliseconds = totalMilliseconds % 1000L;
        long totalSeconds = totalMilliseconds / 1000L;
        long remainderSeconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long remainderMinutes = totalMinutes % 60L;
        long totalHoures = totalMinutes / 60L;
        return ToolLogger.leadingZeroIfLessThanTen(totalHoures) + ":" + ToolLogger.leadingZeroIfLessThanTen(remainderMinutes) + ":" + ToolLogger.leadingZeroIfLessThanTen(remainderSeconds) + "." + ToolLogger.leadingTwoZerosIfLessThanTen(remainderMilliseconds);
    }

    private static String leadingZeroIfLessThanTen(long in) {
        String prepend = "";
        if (in < 10L) {
            prepend = "0";
        }
        return prepend + in;
    }

    private static String leadingTwoZerosIfLessThanTen(long in) {
        String prepend = "";
        if (in < 100L) {
            prepend = "0";
        }
        if (in < 10L) {
            prepend = "00";
        }
        return prepend + in;
    }

    public void error(Exception e) {
        Logger.warn(ToolLogger.class, e);
    }

    public void error(String msg) {
        Logger.warn(ToolLogger.class, msg);
    }

    public void error(Exception e, String msg1, String msg2) {
        if (e != null) {
            Logger.warn(ToolLogger.class, e);
        }
        if (msg1 != null) {
            Logger.warn(ToolLogger.class, msg1);
        }
        if (msg2 != null) {
            Logger.warn(ToolLogger.class, msg2);
        }
    }
}

