/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Calendar;
import oracle.dbtools.raptor.nls.OraConstants;

public class OraConversions
implements OraConstants {
    public static int convertYear(byte[] bytes) {
        return ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
    }

    public static int convertNanos(byte[] bytes) {
        return ((bytes[7] & 0xFF) << 24) + ((bytes[8] & 0xFF) << 16) + ((bytes[9] & 0xFF) << 8) + (bytes[10] & 0xFF);
    }

    public static Instant toInstant(Calendar calendar, Integer nanos) {
        OraConversions.checkNanosRange(nanos);
        Instant instant = calendar.toInstant();
        if (nanos != null) {
            instant = Instant.ofEpochSecond(instant.getEpochSecond(), nanos.intValue());
        }
        return instant;
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar, Integer nanos) {
        return ZonedDateTime.ofInstant(OraConversions.toInstant(calendar, nanos), calendar.getTimeZone().toZoneId());
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static Instant toInstant(long timeInMillis, Integer nanos) {
        OraConversions.checkNanosRange(nanos);
        Instant instant = Instant.ofEpochMilli(timeInMillis);
        if (nanos != null) {
            instant = Instant.ofEpochSecond(instant.getEpochSecond(), nanos.intValue());
        }
        return instant;
    }

    public static void checkNanosRange(Integer nanos) throws IllegalArgumentException {
        if (nanos != null && (nanos > 999999999 || nanos < 0)) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
    }
}

