/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypedList<E>
implements Function<String, List<E>> {
    private static final Pattern LIST_PATTERN = Pattern.compile("(?:(?:'(?:[^']|'')*')|(?:\"(?:[^\"]|\"\")*\")|,|(?:\\s+)|(?:[^\\s,'\"]+))");
    private static final Pattern ESCAPES_SINGLE_PATTERN = Pattern.compile("''");
    private static final Pattern ESCAPES_DOUBLE_PATTERN = Pattern.compile("\"\"");
    private final Function<String, E> elementTransformer;

    public TypedList(Function<String, E> elementTransformer) {
        this.elementTransformer = elementTransformer;
    }

    @Override
    public List<E> apply(String value) {
        List<String> rawElements = this.split(value);
        ArrayList<E> elements = new ArrayList<E>();
        for (String rawElement : rawElements) {
            elements.add(this.elementTransformer.apply(rawElement));
        }
        return elements;
    }

    private List<String> split(String value) {
        ArrayList<String> elements = new ArrayList<String>();
        Matcher lineMatcher = LIST_PATTERN.matcher(value);
        boolean firstNonWhite = true;
        boolean previousComma = false;
        while (lineMatcher.find()) {
            String reducedValue;
            String wordMatch = lineMatcher.group(0);
            if (wordMatch.equals(",")) {
                if (firstNonWhite || previousComma) {
                    elements.add("");
                }
                previousComma = true;
                firstNonWhite = false;
                continue;
            }
            if (wordMatch.isBlank()) continue;
            Pattern escapesPattern = null;
            if (wordMatch.length() > 1) {
                char first = wordMatch.charAt(0);
                if (first == '\'') {
                    escapesPattern = ESCAPES_SINGLE_PATTERN;
                } else if (first == '\"') {
                    escapesPattern = ESCAPES_DOUBLE_PATTERN;
                }
            }
            if (escapesPattern != null) {
                String dequotedWord = wordMatch.substring(1, wordMatch.length() - 1);
                Matcher escapesMatcher = escapesPattern.matcher(dequotedWord);
                StringBuilder sbuf = new StringBuilder();
                int charNo = 0;
                while (escapesMatcher.find()) {
                    String escapesMatch = escapesMatcher.group();
                    int escapesStart = escapesMatcher.start();
                    int escapesEnd = escapesMatcher.end();
                    switch (escapesMatch) {
                        case "''": {
                            sbuf.append(dequotedWord.substring(charNo, escapesStart));
                            sbuf.append("'");
                            break;
                        }
                        case "\"\"": {
                            sbuf.append(dequotedWord.substring(charNo, escapesStart));
                            sbuf.append("\"");
                        }
                    }
                    charNo = escapesEnd;
                }
                sbuf.append(dequotedWord.substring(charNo));
                reducedValue = sbuf.toString();
            } else {
                reducedValue = wordMatch;
            }
            elements.add(reducedValue);
            previousComma = false;
            firstNonWhite = false;
        }
        return elements;
    }
}

