/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class TypedEnum<T>
implements Function<String, T> {
    private final Set<T> items = new HashSet<T>();
    private final Function<String, T> itemTransformer;

    public TypedEnum(Function<String, T> itemTransformer, T ... items) {
        for (T item : items) {
            this.items.add(item);
        }
        this.itemTransformer = itemTransformer;
    }

    @Override
    public T apply(String value) {
        T item = this.itemTransformer.apply(value);
        if (!this.items.contains(item)) {
            throw new IllegalArgumentException();
        }
        return item;
    }
}

