/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PrimitiveTransformers {
    private static final Map<Class<?>, Function<String, ?>> TRANSFORMER_MAP = new HashMap();

    public static <T> Function<String, T> get(Class<T> cls) {
        Function<String, ?> result = TRANSFORMER_MAP.get(cls);
        if (result == null) {
            throw new IllegalArgumentException(cls.getSimpleName());
        }
        return result;
    }

    private PrimitiveTransformers() {
    }

    static {
        TRANSFORMER_MAP.put(Boolean.class, value -> Boolean.valueOf(value));
        TRANSFORMER_MAP.put(String.class, value -> value);
        TRANSFORMER_MAP.put(Byte.class, value -> Byte.valueOf(value));
        TRANSFORMER_MAP.put(Short.class, value -> Short.valueOf(value));
        TRANSFORMER_MAP.put(Integer.class, value -> Integer.valueOf(value));
        TRANSFORMER_MAP.put(Long.class, value -> Long.valueOf(value));
        TRANSFORMER_MAP.put(Float.class, value -> Float.valueOf(value));
        TRANSFORMER_MAP.put(Double.class, value -> Double.valueOf(value));
        TRANSFORMER_MAP.put(Character.class, value -> {
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException();
        });
    }
}

