/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.sql.Connection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.utils.NLSUtils;

public class HelpBundleBuilder {
    private final String bundleName;
    private Locale locale;
    private ClassLoader classLoader;

    public HelpBundleBuilder(String bundleName) {
        this.bundleName = bundleName;
    }

    public HelpBundleBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public HelpBundleBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public HelpContainer build() {
        if (this.locale == null) {
            this.locale = this.getDefaultLocale();
        }
        return new HelpContainerImpl(this);
    }

    private Locale getDefaultLocale() {
        ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();
        if (ctx != null) {
            Connection conn = ctx.getCurrentConnection();
            return NLSUtils.getNLSSessionLocale(conn);
        }
        return Locale.getDefault();
    }

    private static class HelpContainerImpl
    implements HelpContainer {
        private final String bundleName;
        private final Locale locale;
        private final ClassLoader classLoader;

        public HelpContainerImpl(HelpBundleBuilder builder) {
            this.bundleName = builder.bundleName;
            this.locale = builder.locale;
            this.classLoader = builder.classLoader;
        }

        @Override
        public String getContainerName() {
            return this.bundleName;
        }

        @Override
        public Optional<String> get(String key) {
            ResourceBundle resourceBundle = this.getResourceBundle();
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                return Optional.of(resourceBundle.getString(key));
            }
            return Optional.empty();
        }

        private ResourceBundle getResourceBundle() {
            try {
                if (this.classLoader != null) {
                    return ResourceBundle.getBundle(this.bundleName, this.locale, this.classLoader);
                }
                return ResourceBundle.getBundle(this.bundleName, this.locale);
            }
            catch (MissingResourceException ex) {
                Logger.getLogger(this.getClass().getName()).severe(ex.getMessage());
                return null;
            }
        }
    }
}

