/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.help.AbstractPageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStringExtension;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AbbreviatedItem;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedItem;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class CommandPageAssemblers
implements Iterable<PageAssembler> {
    private final Type rootType;
    private final Set<Type> excludedTypes;
    private List<PageAssembler> pages;

    public CommandPageAssemblers(Type rootType, Type ... excludeTypes) {
        this.rootType = rootType;
        this.excludedTypes = new HashSet<Type>(Arrays.asList(excludeTypes));
    }

    @Override
    public Iterator<PageAssembler> iterator() {
        return this.getPages().iterator();
    }

    private List<PageAssembler> getPages() {
        if (this.pages == null) {
            this.pages = new ArrayList<PageAssembler>();
            this.addPages(Collections.singletonList(this.rootType), this.pages);
        }
        return this.pages;
    }

    private void addPages(List<Type> typePath, List<PageAssembler> helpAssemblers) {
        if (!this.excludedTypes.contains(typePath.get(typePath.size() - 1))) {
            helpAssemblers.add(new CommandPageAssembler(typePath));
            helpAssemblers.add(new ExamplesPageAssembler(typePath));
        }
        Type type = typePath.get(typePath.size() - 1);
        for (Type nestedType : type.getNestedTypes()) {
            ArrayList<Type> nestedTypePath = new ArrayList<Type>(typePath);
            nestedTypePath.add(nestedType);
            this.addPages(nestedTypePath, helpAssemblers);
        }
    }

    private static class ExamplesPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private ExamplesPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            buff.append("/EXAMPLES");
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, HelpStrings helpStrings, List<String> moreHelpTopics) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            StringBuilder buff = new StringBuilder();
            buff.append(helpStrings.get(Extensions.EXAMPLES, type.getHelpId()));
            return buff.toString();
        }
    }

    private static class CommandPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private CommandPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, HelpStrings helpStrings, List<String> moreHelpTopics) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            StringBuilder buff = new StringBuilder();
            buff.append(helpStrings.get(type.getHelpId()));
            if (!type.isBase()) {
                this.appendUsage(buff);
            }
            if (!type.getNestedTypes().isEmpty()) {
                this.appendNestedTypes(alphaSort, helpStrings, buff);
            }
            if (!type.getOptions().isEmpty()) {
                this.appendOptions(alphaSort, helpStrings, buff);
            }
            if (!type.getParameters().isEmpty()) {
                this.appendParameters(alphaSort, helpStrings, buff);
            }
            if (!moreHelpTopics.isEmpty()) {
                this.appendMoreTopics(alphaSort, moreHelpTopics, buff);
            }
            return buff.toString();
        }

        private void appendUsage(StringBuilder buff) {
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.USAGE_TITLE)).append('\n');
            boolean first = true;
            for (Type type : this.typePath) {
                if (first) {
                    buff.append("\t");
                } else {
                    buff.append(" ");
                }
                buff.append('$').append(this.encodeName(type).toLowerCase()).append('$');
                for (String abbrev : type.getAbbreviations()) {
                    buff.append('|').append('$').append(abbrev.toLowerCase()).append('$');
                }
            }
            Type type = this.typePath.get(this.typePath.size() - 1);
            if (!type.getNestedTypes().isEmpty()) {
                buff.append(" {SUBCOMMAND}");
            }
            if (!type.getOptions().isEmpty()) {
                buff.append(" {OPTIONS}");
            }
            if (!type.getParameters().isEmpty()) {
                buff.append(" {PARAMETERS}");
            }
        }

        private void appendNestedTypes(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.SUBCOMMANDS_TITLE));
            boolean first = true;
            for (Type nestedType : this.sortItemList(alphaSort, type.getNestedTypes())) {
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$").append(this.encodeName(nestedType).toLowerCase()).append('$');
                for (String abbrev : nestedType.getAbbreviations()) {
                    buff.append("|$").append(abbrev.toLowerCase()).append('$');
                }
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, nestedType.getHelpId()));
            }
        }

        private void appendOptions(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.OPTIONS_TITLE));
            boolean first = true;
            for (Option option : this.sortItemList(alphaSort, type.getOptions())) {
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$-").append(this.encodeName(option).toLowerCase()).append('$');
                for (String abbrev : option.getAbbreviations()) {
                    buff.append("|$").append(abbrev.toLowerCase()).append('$');
                }
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, option.getHelpId()));
            }
        }

        private void appendParameters(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.PARAMETERS_TITLE));
            boolean first = true;
            for (Parameter parameter : this.sortItemList(alphaSort, type.getParameters())) {
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$<").append(parameter.getName().toLowerCase()).append(">$");
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, parameter.getHelpId()));
            }
        }

        private void appendMoreTopics(boolean alphaSort, List<String> moreHelpCommands, StringBuilder buff) {
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.MORE_TITLE));
            for (String moreHelpCommand : this.sortStringList(alphaSort, moreHelpCommands)) {
                buff.append("\n\t").append(moreHelpCommand);
            }
        }

        private <T extends NamedItem> List<T> sortItemList(boolean alphaSort, List<T> items) {
            return alphaSort ? items.stream().sorted((left, right) -> left.getName().compareTo(right.getName())).collect(Collectors.toList()) : items;
        }

        private List<String> sortStringList(boolean alphaSort, List<String> items) {
            return alphaSort ? items.stream().sorted((left, right) -> left.compareTo((String)right)).collect(Collectors.toList()) : items;
        }

        private String encodeName(AbbreviatedItem abbreviatedItems) {
            String name;
            Optional<String> truncationsOpt = abbreviatedItems.getTruncations();
            if (truncationsOpt.isPresent()) {
                String truncation = truncationsOpt.get();
                StringBuilder buff = new StringBuilder();
                buff.append(truncation).append("[").append(abbreviatedItems.getName().substring(truncation.length())).append("]");
                name = buff.toString();
            } else {
                name = abbreviatedItems.getName();
            }
            return name;
        }
    }

    public static enum Extensions implements HelpStringExtension
    {
        EXAMPLES{

            @Override
            public String getDefault() {
                return "EX";
            }
        };

    }
}

