/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.validators;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class DateTimeValidator
extends AbstractValidatorService<Date> {
    @Override
    public Date getParameter(String parm) throws ParameterFailedValidationException {
        try {
            DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.dateFmtStr);
            String dateStr = parm.replaceAll("^\"|\"$", "");
            LocalDateTime localdatetime = LocalDateTime.parse(dateStr, dateFormat);
            Timestamp timestamp = Timestamp.valueOf(localdatetime.format(DateTimeFormatter.ofPattern(this.dateFmtStr)));
            Date outputDate = new Date(timestamp.getTime());
            return outputDate;
        }
        catch (Exception e) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", parm, this.pName, "Bad date format " + this.dateFmtStr));
        }
    }

    @Override
    public String parmToString() {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.dateFmtStr);
        return dateFormat.format(((Date)this.parmValue).toInstant());
    }

    @Override
    public List<Date> StringToTypeList(String stringList) {
        try {
            String[] tempArray;
            for (String date : tempArray = stringList.split(",")) {
                this.allowedValues.add(this.getParameter(date));
            }
            return this.allowedValues;
        }
        catch (Exception e) {
            return null;
        }
    }
}

