/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowTopLevel
implements IShowCommand {
    private static final String[] SHOWTOPLEVEL = new String[]{"toplevel"};

    @Override
    public String[] getShowAliases() {
        return SHOWTOPLEVEL;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return ShowTopLevel.doShowTopLevel(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private static boolean doShowTopLevel(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            boolean b = ctx.getTopLevel();
            ctx.write("Toplevel ");
            if (b) {
                ctx.write("TRUE \n");
            } else {
                ctx.write("FALSE     SCRIPT_DEPTH " + (Integer)ctx.getProperty("script.runner.script_depth"));
            }
        }
        catch (Exception e) {
            Logger.getLogger("ShowTopLevel").log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }
}

