/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowNewPage
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNEWPAGE = new String[]{"newpage", "newp"};

    @Override
    public String[] getShowAliases() {
        return SHOWNEWPAGE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block3: {
            if (ctx.getProperty("script.runner.newpage") != null) {
                String value = ctx.getProperty("script.runner.newpage").toString();
                try {
                    int np = Integer.parseInt(value);
                    ctx.write(MessageFormat.format(Messages.getString("ShowNewPage.2"), np));
                }
                catch (NumberFormatException e) {
                    if (!value.equalsIgnoreCase("NONE")) break block3;
                    ctx.write(Messages.getString("ShowNewPage.4"));
                }
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("newpage", String.valueOf(ctx.getProperty("script.runner.newpage")));
    }
}

