/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowCopyc
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWCOPYC = new String[]{"copyc", "copyco", "copycom", "copycomm", "copycommi", "copycommit"};

    @Override
    public String[] getShowAliases() {
        return SHOWCOPYC;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowCopyc(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowCopyc(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getProperty("script.runner.copycommit") != null) {
                ctx.write("copycommit " + (String)ctx.getProperty("script.runner.copycommit") + "\n");
            } else {
                ctx.write("copycommit 0");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.getProperty("script.runner.copycommit") != null) {
            return StoreRegistry.getCommand("copycommit", String.valueOf(ctx.getProperty("script.runner.copycommit")));
        }
        return StoreRegistry.getCommand("copycommit", String.valueOf(0));
    }
}

