/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class OracleConnectorType
extends OracleStandardFormConnectorType {
    @Override
    public String getName() {
        return "ORACLE";
    }

    @Override
    public String getShortName() {
        return "O";
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        super.parseConnectionSpec(args);
        String url = args.getPropertyValue(URLProperty.URL);
        if (url != null && SQLPLUSUtil.hasAnyStub(url) && !SQLPLUSUtil.hasOracleDBStub(url)) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PREFIX), this.getName(), url));
        }
    }

    @Override
    public OracleConnector createConnector(ConnectorArgs args) {
        return new OracleConnector(args);
    }
}

