/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.SqlnetInstance;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnector
extends OracleStandardFormConnector {
    public OracleConnector(ConnectorArgs args) {
        super(args);
        String url = this.properties.getValueOf(URLProperty.URL);
        if (url == null) {
            this.properties.setValueOf(URLProperty.URL, CommonServices.get(ConnectorTypeCache.class).getConnectionContext(this.ctx).getCurrentPropertyValues().getValueOf(URLProperty.URL));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> urlMessage, String connectDB, Properties props) {
        String connectName = props.getProperty("user");
        Connection myconn = null;
        Object successfulAttempt = null;
        Boolean useOci = (Boolean)this.ctx.getProperty("DBConfig.USE_THICK_DRIVER");
        if ((connectDB == null || connectDB.equals("")) && this.ctx.getProperty("script.runner.jline") != null) {
            String envValue;
            String envToCheck = "TWO_TASK";
            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                envToCheck = "LOCAL";
            }
            if ((envValue = System.getenv(envToCheck)) != null && !envValue.equals("")) {
                connectDB = envValue;
            }
        }
        if (connectDB != null && !connectDB.equals("")) {
            Object url;
            int match = -1;
            myconn = null;
            ArrayList<TCPTNSEntry> myTCPEntry = null;
            String preExpand = null;
            if (match == -1) {
                String tryLDAP = null;
                if (this.ctx.getProperty("script.runner.ldapcon") != null && ((String)this.ctx.getProperty("script.runner.ldapcon")).contains("#ENTRY#")) {
                    tryLDAP = ((String)this.ctx.getProperty("script.runner.ldapcon")).replace("#ENTRY#", connectDB);
                }
                if (tryLDAP == null && System.getenv("LDAPCON") != null && System.getenv("LDAPCON").contains("#ENTRY#")) {
                    tryLDAP = System.getenv("LDAPCON").replace("#ENTRY#", connectDB);
                }
                if (tryLDAP != null) {
                    try {
                        myconn = this.logConnectionURL(urlMessage, connectName, tryLDAP, props, true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (myconn == null && (myTCPEntry = TNSHelper.getTNSEntries()) != null) {
                    for (int i = 0; i < myTCPEntry.size(); ++i) {
                        if (!myTCPEntry.get(i).getName().toUpperCase().equals(connectDB.toUpperCase())) continue;
                        preExpand = connectDB;
                        match = i;
                        break;
                    }
                }
            }
            if (match == -1 && connectDB.indexOf("/") == -1 && connectDB.indexOf("\\") == -1 && connectDB.indexOf(":") == -1) {
                String netVal;
                String connectDBnoDot = connectDB;
                int indexdot = connectDBnoDot.indexOf(".");
                if (indexdot != -1) {
                    connectDBnoDot = connectDBnoDot.substring(0, indexdot);
                }
                if (myTCPEntry != null) {
                    for (int i = 0; i < myTCPEntry.size(); ++i) {
                        String theEntry = myTCPEntry.get(i).getName();
                        int indexdot2 = theEntry.indexOf(".");
                        if (indexdot2 != -1) {
                            theEntry = theEntry.substring(0, indexdot2);
                        }
                        if (!theEntry.toUpperCase().equals(connectDBnoDot.toUpperCase())) continue;
                        match = i;
                        break;
                    }
                }
                if (match == -1 && this.ctx.isCommandLine() && (this.ctx.getProperty("script.runner.setnet") == null || (String)this.ctx.getProperty("script.runner.setnet") != null && !((String)this.ctx.getProperty("script.runner.setnet")).equals("OFF")) && (netVal = NetEntries.getInstance().get(connectDB)) != null) {
                    String lookUp = netVal;
                    if (SQLPLUSUtil.hasUrlStub(lookUp)) {
                        try {
                            myconn = this.logConnectionURL(urlMessage, connectName, lookUp, props, true);
                        }
                        catch (Throwable ee) {
                            myconn = null;
                            this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                        }
                    } else {
                        try {
                            if (!useOci.booleanValue()) {
                                throw new Exception();
                            }
                            String url2 = "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(lookUp);
                            myconn = this.logConnectionURL(urlMessage, connectName, url2, props, true);
                        }
                        catch (Throwable e) {
                            try {
                                String url3 = "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(lookUp);
                                myconn = this.logConnectionURL(urlMessage, connectName, url3, props, true);
                            }
                            catch (Throwable ee) {
                                myconn = null;
                                this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                            }
                        }
                    }
                }
            }
            if (useOci == null) {
                useOci = Boolean.FALSE;
            }
            if (match == -1 && myconn == null) {
                String[] both;
                String url4;
                if (SQLPLUSUtil.hasUrlStub(connectDB)) {
                    try {
                        myconn = this.logConnectionURL(urlMessage, connectName, connectDB, props, true);
                    }
                    catch (Throwable ee) {
                        myconn = null;
                        this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                    }
                } else {
                    try {
                        if (!useOci.booleanValue()) {
                            throw new Exception();
                        }
                        url = "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(connectDB);
                        myconn = this.logConnectionURL(urlMessage, connectName, (String)url, props, true);
                        successfulAttempt = connectDB;
                    }
                    catch (Throwable e) {
                        try {
                            url4 = "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(connectDB);
                            myconn = this.logConnectionURL(urlMessage, connectName, url4, props, true);
                            successfulAttempt = connectDB;
                        }
                        catch (Throwable ee) {
                            myconn = null;
                            this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                        }
                    }
                }
                if (myconn != null || SQLPLUSUtil.hasUrlStub(connectDB) || connectDB.indexOf("(") != -1) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                String startConnectDB = connectDB;
                if (!connectDB.matches("^[^:]+\\:[0-9]+\\/.*") && connectDB.indexOf("/") != -1 && connectDB.substring(connectDB.indexOf("/") + 1).indexOf("/") == -1) {
                    connectDB = connectDB.replaceAll("/", ":1521/");
                    try {
                        if (!useOci.booleanValue()) {
                            throw new Exception();
                        }
                        url4 = "jdbc:oracle:oci8:@" + connectDB;
                        myconn = this.logConnectionURL(urlMessage, connectName, url4, props, true);
                        successfulAttempt = connectDB;
                    }
                    catch (Throwable e) {
                        try {
                            String url5 = "jdbc:oracle:thin:@" + connectDB;
                            myconn = this.logConnectionURL(urlMessage, connectName, url5, props, true);
                            successfulAttempt = connectDB;
                        }
                        catch (Throwable ee) {
                            myconn = null;
                        }
                    }
                }
                if (myconn != null || startConnectDB.indexOf(":") != -1 && (startConnectDB.endsWith(":") || startConnectDB.substring(startConnectDB.indexOf(":") + 1).indexOf(":") == -1 || startConnectDB.indexOf("/") != -1)) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                String noDot = null;
                String withDot = null;
                String startConnectDB2 = null;
                try {
                    InetAddress addr = InetAddress.getByAddress(InetAddress.getByName(startConnectDB).getAddress());
                    startConnectDB2 = addr.getCanonicalHostName();
                }
                catch (UnknownHostException uhe) {
                    startConnectDB2 = null;
                }
                for (String ident : both = new String[]{startConnectDB, startConnectDB2}) {
                    String url6;
                    if (ident == null) continue;
                    if (myconn != null) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                    noDot = ident.indexOf(".") == -1 ? ident : ident.substring(0, ident.indexOf("."));
                    boolean onlyNumber = true;
                    try {
                        Integer.parseInt(noDot);
                    }
                    catch (NumberFormatException nfe) {
                        onlyNumber = false;
                    }
                    try {
                        if (!onlyNumber) {
                            url6 = "jdbc:oracle:thin:@" + ident + ":1521/" + noDot;
                            myconn = this.logConnectionURL(urlMessage, connectName, url6, props, false);
                            successfulAttempt = ident + ":1521/" + noDot;
                        }
                    }
                    catch (Throwable ee) {
                        myconn = null;
                    }
                    if (myconn != null || ident.indexOf(".") == -1) continue;
                    withDot = ident;
                    try {
                        if (onlyNumber) continue;
                        url6 = "jdbc:oracle:thin:@" + ident + ":1521/" + withDot;
                        myconn = this.logConnectionURL(urlMessage, connectName, url6, props, false);
                        successfulAttempt = ident + ":1521/" + withDot;
                    }
                    catch (Throwable ee) {
                        myconn = null;
                    }
                }
                return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            }
            if (myconn != null) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            if (SQLPLUSUtil.hasUrlStub(((TCPTNSEntry)myTCPEntry.get(match)).getSpecUrl())) {
                try {
                    myconn = this.logConnectionURL(urlMessage, connectName, myTCPEntry.get(match).getSpecUrl(), props, true);
                    return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                }
                catch (Throwable ee) {
                    myconn = null;
                    this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                }
                return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            }
            try {
                if (!useOci.booleanValue()) {
                    throw new Exception();
                }
                url = "";
                url = preExpand == null || preExpand.equals("") ? "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(myTCPEntry.get(match).getSpecUrl()) : "jdbc:oracle:oci8:@" + preExpand;
                myconn = this.logConnectionURL(urlMessage, connectName, (String)url, props, true);
                return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            }
            catch (Throwable e) {
                try {
                    Object url7 = "";
                    url7 = preExpand == null || preExpand.equals("") ? "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(myTCPEntry.get(match).getSpecUrl()) : "jdbc:oracle:thin:@" + preExpand;
                    myconn = this.logConnectionURL(urlMessage, connectName, (String)url7, props, true);
                    return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                }
                catch (SQLException e2) {
                    if (useOci.booleanValue()) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ScriptRunnerDbArb.getString("OCI_FAILED_TRYING_THIN"));
                    }
                    this.ctx.putProperty("sqldev.last.err.message.forsqlcode", e2.getMessage());
                    if (myconn == null) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                    try {
                        myconn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    myconn = null;
                    return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
                }
                catch (Throwable ee) {
                    myconn = null;
                }
            }
            return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
        }
        try {
            String url8;
            myconn = null;
            try {
                if (useOci.booleanValue()) {
                    url8 = "jdbc:oracle:oci8:@";
                    myconn = this.logConnectionURL(urlMessage, connectName, url8, props, useOci, true);
                }
            }
            catch (Throwable url8) {
                // empty catch block
            }
            if (myconn == null) {
                try {
                    String oracleSid = System.getProperty("ORACLE_SID");
                    if (oracleSid == null && (oracleSid = System.getenv("ORACLE_SID")) != null) {
                        System.setProperty("ORACLE_SID", oracleSid);
                    }
                    if (oracleSid != null && !oracleSid.equals("")) {
                        String url9 = "jdbc:oracle:thin:@127.0.0.1:1521:" + oracleSid;
                        myconn = this.logConnectionURL(urlMessage, connectName, url9, props, true);
                    }
                }
                catch (Throwable oracleSid) {
                    // empty catch block
                }
            }
            if (myconn == null) {
                try {
                    url8 = "jdbc:oracle:thin:@localhost:1521/orcl";
                    myconn = this.logConnectionURL(urlMessage, connectName, url8, props, false);
                }
                catch (Throwable url10) {
                    // empty catch block
                }
            }
            if (myconn != null) return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            try {
                url8 = "jdbc:oracle:thin:@localhost:1521/xe";
                myconn = this.logConnectionURL(urlMessage, connectName, url8, props, false);
                return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
            }
            catch (Throwable url11) {}
            return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
        }
        catch (Throwable e) {
            myconn = null;
        }
        return new StandardFormConnector.ConnectionRec(myconn, (String)successfulAttempt);
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        datasource.setURL(url);
        datasource.setConnectionProperties(filteredProps);
    }
}

