/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Disconnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.DisconnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.HelpContainerRef;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.DefaultDisconnector;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;

public abstract class AbstractConnectorType
implements ConnectorType {
    private final List<Property<?>> properties = new ArrayList();
    private static HelpContainer helpBundle;
    private static final Map<String, Supplier<String>> selectorHelpMap;
    private static final HelpContainer selectorHelpContainer;

    public AbstractConnectorType() {
        this.properties.add(this.createSelectorProperty(this.getName(), this.getShortName(), this.isSelectorMandatory()));
        this.addInheritablePropertiesTo(this.properties);
        this.addPropertiesTo(this.properties);
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    public Disconnector createDisconnector(DisconnectorArgs args) {
        return new DefaultDisconnector(args.getConnection());
    }

    protected boolean isSelectorMandatory() {
        return false;
    }

    protected void addInheritablePropertiesTo(List<Property<?>> properties) {
    }

    protected void addPropertiesTo(List<Property<?>> properties) {
    }

    private FlagProperty createSelectorProperty(final String name, final String shortName, final boolean mandatory) {
        FlagProperty selector = new FlagProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getShortName() {
                return shortName;
            }

            @Override
            public String getHelpId() {
                return this.getName() + "_SELECTOR";
            }

            @Override
            public HelpContainerRef getHelpContainer() {
                return HelpContainerRef.create(selectorHelpContainer);
            }

            @Override
            public boolean matchesNull() {
                return !mandatory;
            }

            @Override
            public boolean isFlag() {
                return true;
            }
        };
        selectorHelpMap.put(selector.getHelpId(), () -> MessageFormat.format(AbstractConnectorType.getHelpBundle().get("SELECTOR_PROPERTY").get(), this.getName().toUpperCase()));
        selectorHelpMap.put(selector.getHelpId() + "_SH", () -> MessageFormat.format(AbstractConnectorType.getHelpBundle().get("SELECTOR_PROPERTY_SH").get(), this.getName().toUpperCase()));
        selectorHelpMap.put(selector.getHelpId() + "_EX", () -> MessageFormat.format(AbstractConnectorType.getHelpBundle().get("SELECTOR_PROPERTY_EX").get(), this.getName().toUpperCase(), this.getName().toLowerCase()));
        return selector;
    }

    private static HelpContainer getHelpBundle() {
        if (helpBundle == null) {
            String bundleName = ConnectorTypeCache.class.getPackageName() + ".Help";
            for (HelpContainer helpContainer : CommonServices.get(ConnectorTypeCache.class).getHelpContainers()) {
                if (!bundleName.equals(helpContainer.getContainerName())) continue;
                helpBundle = helpContainer;
                break;
            }
        }
        return helpBundle;
    }

    static {
        selectorHelpMap = new HashMap<String, Supplier<String>>();
        selectorHelpContainer = new HelpContainer(){

            @Override
            public String getContainerName() {
                return "";
            }

            @Override
            public Optional<String> get(String key) {
                Supplier<String> supplier = selectorHelpMap.get(key);
                if (supplier != null) {
                    return Optional.ofNullable(supplier.get());
                }
                return Optional.empty();
            }
        };
    }
}

