/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.util.Objects;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NamedObject;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;

public abstract class HelpContainerRef {
    public abstract HelpContainer get();

    public static HelpContainerRef create(NamedObject source) {
        return new BundleContainerRef(source);
    }

    public static HelpContainerRef create(HelpContainer helpContainer) {
        return new PureContainerRef(helpContainer);
    }

    private HelpContainerRef() {
    }

    private static class PureContainerRef
    extends HelpContainerRef {
        private final HelpContainer helpContainer;

        private PureContainerRef(HelpContainer helpContainer) {
            this.helpContainer = helpContainer;
        }

        @Override
        public HelpContainer get() {
            return this.helpContainer;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.helpContainer);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PureContainerRef other = (PureContainerRef)obj;
            return this.helpContainer == other.helpContainer;
        }
    }

    private static class BundleContainerRef
    extends HelpContainerRef {
        private final NamedObject source;
        private HelpContainer helpContainer;

        private BundleContainerRef(NamedObject source) {
            this.source = source;
        }

        @Override
        public HelpContainer get() {
            if (this.helpContainer == null) {
                this.helpContainer = new HelpBundleBuilder(this.source.getClass().getPackageName() + ".Help").classLoader(this.source.getClass().getClassLoader()).build();
            }
            return this.helpContainer;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + Objects.hashCode(this.source.getClass().getPackageName());
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BundleContainerRef other = (BundleContainerRef)obj;
            return this.source.getClass().getPackageName().equals(other.source.getClass().getPackageName());
        }
    }
}

