/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

public class CopyToOracleHint {
    private String _query = null;
    private String _queryWithoutHint = null;
    private boolean _hasCopyToOracleHint = false;
    private String _catalog = null;
    private String _schema = null;
    private String _table = null;
    public static final String COPYTOORACLEHINT = "/*CTO:";

    public CopyToOracleHint(String query) {
        this._query = query;
        if (query != null) {
            if (this._query.indexOf(COPYTOORACLEHINT) != -1) {
                this._hasCopyToOracleHint = true;
            }
            if (this._hasCopyToOracleHint) {
                this._queryWithoutHint = this.removeCopyToOracleHint(this._query);
                this.processHint(this._query);
            } else {
                this._queryWithoutHint = this._query;
            }
        }
    }

    private void processHint(String query) {
        if (query != null) {
            int startHint = query.indexOf(COPYTOORACLEHINT);
            int endHint = query.indexOf("*/", startHint);
            if (startHint != -1 && endHint != -1) {
                String hint = query.substring(startHint, endHint);
                String[] hints = hint.split(":");
                this._catalog = hints[1];
                this._schema = hints[2];
                this._table = hints[3];
            }
        }
    }

    public boolean isCopyToOracle() {
        return this._hasCopyToOracleHint;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getTable() {
        return this._table;
    }

    private String removeCopyToOracleHint(String query) {
        if (query != null) {
            int startHint = query.indexOf(COPYTOORACLEHINT);
            int endHint = query.indexOf("*/", startHint);
            if (startHint != -1 && endHint != -1) {
                query = query.substring(endHint + 2);
            }
        }
        return query;
    }

    public static String createCopyToOracleHint(String dbName, String schema, String name) {
        return COPYTOORACLEHINT + dbName + ":" + schema + ":" + name + "*/";
    }

    public String queryWithoutHint() {
        return this._queryWithoutHint;
    }

    public String getFullName() {
        if (this.getCatalog() != null && this.getSchema() != null) {
            return this.getCatalog() + "." + this.getSchema() + "." + this.getTable();
        }
        if (this.getCatalog() != null && this.getSchema() == null) {
            return this.getCatalog() + ".." + this.getTable();
        }
        if (this.getCatalog() == null && this.getSchema() != null) {
            return this.getSchema() + "." + this.getTable();
        }
        return this.getTable();
    }
}

