/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeException;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeParserException;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableDef;

public class BridgeParser {
    public static final String CMD = "BRIDGE";
    private ArrayList<BridgeTableDef> _tableDefs = new ArrayList();
    private String _query = null;

    BridgeParser(String str) throws BridgeParserException {
        try {
            String stmt = str.trim();
            int start = 0;
            if (stmt.toUpperCase().startsWith("/*SQLDEV:SCRIPTTABLE*/")) {
                stmt = stmt.substring("/*SQLDEV:SCRIPTTABLE*/".length()).trim();
                start = "/*SQLDEV:SCRIPTTABLE*/".length();
            }
            if (stmt.toUpperCase().startsWith(CMD)) {
                this.processCMD(str.substring(start));
            }
        }
        catch (Exception e) {
            throw new BridgeParserException(e);
        }
    }

    private void processCMD(String stmt) throws Exception {
        int end;
        String stmtLower = stmt.toUpperCase();
        int start = stmtLower.indexOf(CMD);
        start = end = start + CMD.length();
        this.processRemainingStmt(stmt, start);
    }

    private void processRemainingStmt(String stmt, int start) throws Exception {
        int end2;
        String stmtLower = stmt.toLowerCase();
        int end = stmtLower.indexOf(" as", start);
        if (end != -1) {
            ++end;
        }
        if ((end2 = stmtLower.indexOf(")as", start)) != -1 && end2 < end) {
            end = end2 + 1;
        }
        if ((end2 = stmtLower.indexOf("\nas", start)) != -1 && end2 < end) {
            end = end2 + 1;
        }
        if ((end2 = stmtLower.indexOf("\tas", start)) != -1 && end2 < end) {
            end = end2 + 1;
        }
        String tableNameDetails = stmt.substring(start, end).trim();
        String tableConn = null;
        String tableName = tableNameDetails;
        int tableConnIndex = tableNameDetails.indexOf("(");
        if (tableConnIndex != -1) {
            tableConn = tableNameDetails.substring(0, tableConnIndex);
            tableName = tableNameDetails.substring(tableConnIndex + 1, tableNameDetails.indexOf(")"));
        }
        start = end + 2;
        end = this.findMatchingBracket(stmtLower, start, -1);
        String tableDefDetails = stmt.substring(start, end).trim();
        String tableDefConn = null;
        int tableDefIndex = tableDefDetails.indexOf("(");
        if (tableDefIndex == 0) {
            tableDefDetails = tableDefDetails.substring(1, tableDefDetails.length());
        } else {
            tableDefConn = tableDefDetails.substring(0, tableDefIndex);
            tableDefDetails = tableDefDetails.substring(tableDefIndex + 1, tableDefDetails.length());
        }
        start = end;
        String queryStmt = null;
        String remainingStmt = stmtLower.substring(start).trim();
        boolean isAppend = false;
        boolean isReplace = false;
        boolean isTruncate = false;
        boolean isSkip = false;
        if (remainingStmt.startsWith(")append")) {
            isAppend = true;
            remainingStmt = stmtLower.substring(start += 7).trim();
        } else if (remainingStmt.startsWith(")replace")) {
            isReplace = true;
            remainingStmt = stmtLower.substring(start += 8).trim();
        } else if (remainingStmt.startsWith(")truncate")) {
            isTruncate = true;
            remainingStmt = stmtLower.substring(start += 9).trim();
        } else if (remainingStmt.startsWith(")skip")) {
            isSkip = true;
            remainingStmt = stmtLower.substring(start += 5).trim();
        } else if (remainingStmt.startsWith(")")) {
            remainingStmt = stmtLower.substring(++start).trim();
        }
        this._tableDefs.add(new BridgeTableDef(tableName, this.getConnection(tableConn), tableDefDetails, this.getConnection(tableDefConn), isAppend, isReplace, isTruncate, isSkip));
        if (remainingStmt.startsWith(",")) {
            start = stmt.indexOf(",", start) + 1;
            String substring = stmt.substring(start);
            String substringLower = stmtLower.substring(start);
            this.processRemainingStmt(stmt, start);
        } else {
            queryStmt = stmt.substring(start).trim();
            if (queryStmt.length() == 0 || queryStmt.equals(";") || queryStmt.equals("/")) {
                queryStmt = null;
            }
            this._query = queryStmt;
        }
    }

    private Connection getConnection(String connStr) throws Exception {
        Connection conn = null;
        if (connStr == null) {
            return null;
        }
        try {
            if (connStr.startsWith("\"")) {
                conn = ConnectionResolver.getConnection(connStr);
            } else {
                boolean cloneConnection = false;
                if (connStr.startsWith("$")) {
                    cloneConnection = true;
                    connStr = connStr.substring(1);
                }
                String qualifiedName = ConnectionResolver.getQualifiedConnectionName(connStr);
                conn = cloneConnection ? ConnectionResolver.getUniqueConnection(qualifiedName) : ConnectionResolver.getConnection(qualifiedName);
            }
        }
        catch (Throwable t) {
            throw new BridgeException(MessageFormat.format(Messages.getString("BRIDGE_TABLE_FAIL_CREATE_CONNECTION"), connStr), t);
        }
        if (conn == null) {
            throw new BridgeException(MessageFormat.format(Messages.getString("BRIDGE_TABLE_FAIL_CREATE_CONNECTION"), connStr));
        }
        return conn;
    }

    private int findMatchingBracket(String stmtLower, int start, int nestLevel) {
        if (start == -1) {
            throw new IllegalArgumentException();
        }
        int rBracket = stmtLower.indexOf(")", start + 1);
        int lBracket = stmtLower.indexOf("(", start + 1);
        if (lBracket != -1 && lBracket < rBracket) {
            return this.findMatchingBracket(stmtLower, lBracket, ++nestLevel);
        }
        if (nestLevel == 0) {
            return rBracket;
        }
        return this.findMatchingBracket(stmtLower, rBracket, --nestLevel);
    }

    public ArrayList<BridgeTableDef> getTableDefs() {
        return this._tableDefs;
    }

    public String getQuery() {
        return this._query;
    }
}

