/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.nio.file.Path;
import java.sql.Connection;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class WhichCommand
extends CommandListener
implements IHelp {
    private static final String WHICH = "WHICH";

    @Override
    public String getCommand() {
        return WHICH;
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand().toUpperCase());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = sqlpcmd.split("\\s+");
        String filename = null;
        switch (cmds.length) {
            case 1: {
                ctx.write(Messages.getString("Usage: which <filename>\n"));
                ctx.write(this.getHelp());
                return true;
            }
            case 2: {
                filename = cmds[1];
                Path path = FileUtils.getFilePath(ctx, filename);
                if (path != null) {
                    ctx.write(path.toAbsolutePath().toString() + "\n");
                }
                return true;
            }
        }
        ctx.write(this.getHelp());
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

